#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\gunfight_sd\game;
#include user_scripts\mp_patches\gunfight_sd\hud;
#include user_scripts\mp_patches\gunfight_sd\utils;

buildMaps(){
    level.hideCrates = false;
	level.randomFlagRadiusX = 150;//Default
	level.randomFlagRadiusY = 150;//Default
	level deletePlacedEntity("misc_turret");
    switch(getDvar("mapname")){
		case "mp_afghan":
            Afghan_Edit();
        break;
		case "mp_compact":
            Salvage_Edit();
        break;
		case "mp_strike":
            Strike_Edit();
        break;
		case "airport":
            Airport_Edit();
        break;
		case "mp_crash":
            Crash_Edit();
        break;
		case "mp_crash_tropical":
            Crash_Edit();
        break;
		case "mp_crash_snow":
            Crash_Edit();
        break;
		case "mp_bloc":
            Bloc_Edit();
        break;
		case "mp_bloc_sh":
            Bloc_Edit();
        break;
		case "mp_complex":
            Bailout_Edit();
        break;
		case "mp_bog_sh":
            Blog_Edit();
        break;
		case "mp_bog_summer":
            Blog_Summer_Edit();
        break;
		case "mp_bog":
            Blog_Edit();
        break;
		case "co_hunted"://village
            Village_Edit();
        break;
        case "mp_rust":
            Rust_Edit();
        break;
        case "mp_shipment":
            Shipment_Edit();
        break;
        case "mp_firingrange":
            FiringRange_Edit();
        break;
        case "mp_terminal":
            Terminal_Edits();
        break;
		case "mp_overgrown":
            Overgrown_Edit();
        break;
		case "mp_brecourt"://wasteland
            Wasteland_Edit();
        break;
		case "mp_rust_long":
            Rust_Long_Edit();
        break;
		case "mp_shipment_long":
            Shipment_Long_Edit();
        break;
		case "mp_boneyard"://scrapyard
            Scrapyard_Edit();
        break;
		case "mp_highrise":
            Highrise_Edit();
        break;
		case "mp_highrise2":
            Highrise_Edit();
        break;
		case "mp_killhouse":
            Killhouse_Edit();
        break;
		case "mp_storm_spring":
            ChemPlant_Edit();
        break;
		case "mp_storm":
            ChemPlant_Edit();
        break;
		case "mp_quarry":
            Quarry_Edit();
        break;
		case "mp_cargoship_sh"://wet work
            CargoShip_Edit();
        break;
		case "mp_cargoship"://wet work
            CargoShip_Edit();
        break;
		case "mp_crossfire":
            CrossFire_Edit();
        break;
		case "mp_favela":
            Favela_Edit();
        break;
		case "mp_fav_tropical":
            Favela_Edit();
        break;
		case "mp_vacant":
            Vacant_Edit();
        break;
		case "mp_invasion":
            Invasion_Edit();
        break;
		case "mp_subbase":
            Subbase_Edit();
        break;
		case "mp_nuked":
            Nuketown_Edit();
        break;
		case "mp_summit":
            Summit_Edit();
        break;
		case "mp_backlot":
            Backlot_Edit();
        break;
		case "mp_betatnl":
            Betatnl_Edit();
        break;
		case "mp_blue_ramshackle":
            Blue_Ramshackle_Edit();
        break;
		case "mp_bo2carrier":
            bo2carrier_Edit();
        break;
		case "mp_bo2standoff":
            bo2standoff_Edit();
        break;
		case "mp_convoy":
            Convoy_Edit();
        break;
		case "mp_countdown":
            Countdown_Edit();
        break;
		case "mp_creek":
            Creek_Edit();
        break;
		case "mp_farm":
            Farm_Edit();
        break;
		case "mp_farm_spring":
            Farm_Edit();
        break;
		case "mp_lost":
            Lost_Edit();
        break;
		case "mp_luna":
            Luna_Edit();
        break;
		case "mp_mw2_rust":
            MW2_Rust_Edit();
        break;
		case "mp_paris":
            Resistance_Edit();
        break;
		case "mp_pipeline":
            Pipeline_Edit();
        break;
		case "mp_rasalem":
            Rasalem_Edit();
        break;
		case "mp_sharqi_day":
            Sharqi_Day_Edit();
        break;
		case "mp_waw_castle":
            Waw_Castle_Edit();
        break;
		case "mp_c4s_minecraft":
            Minecraft_Edit();
        break;
		case "mp_sfs_minecraft":
            MinecraftSFS_Edit();
        break;
		case "mp_derail":
            Derail_Edit();
        break;
		case "mp_checkpoint":
            Karachi_Edit();
        break;
		case "mp_nightshift":
            Skidrow_Edit();
        break;
		case "mp_dome":
            Dome_Edit();
        break;
		case "mp_seatown":
            Seatown_Edit();
        break;
		case "mp_underpass":
            Underpass_Edit();
        break;
		case "mp_estate":
            Estate_Edit();
        break;
		case "mp_estate_tropical":
            Estate_Edit();
        break;
		case "mp_rundown":
            Rundown_Edit();
        break;
		case "cliffhanger":
            Cliffhanger_Edit();
        break;
		case "dcburning":
            DCburning_Edit();
        break;
		case "mp_mountain"://HMW Summit
            Mountain_Edit();
        break;
		case "mp_mogadishu"://HMW Summit
            Bakaara_Edit();
        break;
		default:
			switch(randomint(2)){//places the flag on the A bomb site if the map doesn't have an edit.
			case 0:
				level.randomFlagRadiusX = 100;
				level.randomFlagRadiusY = 100;
				level thread createFlag(getEntArray( "bombzone", "targetname" )[0].origin);
				break;
			case 1:
				level.randomFlagRadiusX = 100;
				level.randomFlagRadiusY = 100;
				level thread createFlag(getEntArray( "bombzone", "targetname" )[1].origin);
				break;
		}
		break;
    }
    level.mapBuilt = true;
}

PrecacheMaps(){
	setDvar("gf_map_edit", randomInt(2));
    switch(getDvar("mapname")){
		case "mp_afghan":
            level thread Afghan_Models();
        break;
        case "mp_firingrange":
            level thread FiringRange_Models();
        break;
        case "mp_terminal":
            level thread Terminal_Models();
        break;
		case "mp_overgrown":
            level thread Overgrown_Models();
        break;
		case "mp_brecourt"://Wasteland
            level thread Wasteland_Models();
        break;
		case "mp_highrise":
            level thread Highrise_Models();
        break;
		case "mp_highrise2":
            level thread Highrise_Models();
        break;
		case "mp_storm_spring":
            level thread ChemPlant_Models();
        break;
		case "mp_storm":
            level thread ChemPlant_Models();
        break;
		case "mp_quarry":
            level thread Quarry_Models();
        break;
		case "mp_favela":
            level thread Favela_Models();
        break;
		case "mp_fav_tropical":
            level thread Favela_Models();
        break;
		case "mp_invasion":
            level thread Invasion_Models();
        break;
		case "mp_paris":
            level thread Resistance_Models();
        break;
		case "mp_subbase":
            level thread Subbase_Models();
        break;
		case "mp_derail":
            level thread Derail_Models();
        break;
		case "mp_checkpoint":
            level thread Karachi_Models();
        break;
		case "mp_nightshift":
            level thread Skidrow_Models();
        break;
		case "mp_seatown":
            level thread Seatown_Models();
        break;
		case "mp_underpass":
            level thread Underpass_Models();
        break;
		case "mp_estate":
            level thread Estate_Models();
        break;
		case "mp_estate_tropical":
            level thread Estate_Models();
        break;
		case "mp_rundown":
            level thread Rundown_Models();
        break;
		case "cliffhanger":
            level thread Cliffhanger_Models();
        break;
		case "dcburning":
            level thread DCburning_Models();
        break;
    }
}

Bakaara_Edit(){
	level thread createFlag((513.89, 924.081, -32.4466));
}


Mountain_Edit(){
	level thread createFlag((2438,-952,320));
}

DCburning_Models()
{
	PrecacheModel("vehicle_taxi_yellow_destructible_dcburning");
	PrecacheModel("vehicle_m1a1_abrams_static");
	PrecacheModel("com_plasticcase_beige_big");
	PrecacheModel("com_folding_table");
	PrecacheModel("com_barrel_blue");
	PrecacheModel("com_vending_can_new3_lit");
	PrecacheModel("h2_dcb_dpt_commerce_ceiling_tile_01");
}

DCburning_Edit(){
	SpawnModel("vehicle_taxi_yellow_destructible_dcburning",(-19926.1, 6133.67, -381.683),(0, 0, 0));
	SpawnModel("vehicle_m1a1_abrams_static",(-22091.8, 6255.4, -322.978),(0, -91, -3));
	SpawnModel("com_plasticcase_beige_big",(-22313.3, 6118.5, -315.968),(0, 0, 0));
	SpawnModel("com_plasticcase_beige_big",(-22313.7, 6120.96, -287.959),(0, 16, 0));
	SpawnModel("com_folding_table",(-22163.4, 6112.01, -300.31),(-88, 11, 77));
	SpawnModel("com_folding_table",(-22014.3, 6110.66, -309.545),(84, -98, -8));
	SpawnModel("com_folding_table",(-21541.2, 6096.54, -337.844),(0, -86, 0));
	SpawnModel("com_barrel_blue",(-21482.5, 6105.87, -339.425),(0, 221.506, 0));
	SpawnModel("com_vending_can_new3_lit",(-21274.2, 6103.99, -321.183),(42, 7, -3));
	SpawnModel("com_vending_can_new3_lit",(-20423.8, 6126.64, -350.106),(0, -92, 40));
	SpawnModel("com_plasticcase_beige_big",(-20781.6, 6110.21, -357.321),(0, 174.512, 0));
	SpawnModel("com_plasticcase_beige_big",(-20785.5, 6107.68, -328.815),(0, 154.177, 0));
	SpawnModel("com_plasticcase_beige_big",(-21541.5, 6097.45, -304.594),(0, 209.498, 0));
	SpawnModel("com_plasticcase_beige_big",(-21439.1, 6116.99, -326.388),(15, -52, 11));
	SpawnModel("com_plasticcase_beige_big",(-21465.8, 6105.72, -296.139),(-5, 177.874, -5));
	SpawnModel("com_plasticcase_beige_big",(-21542.3, 6105.41, -338.4),(0, -47, 0));
	SpawnModel("h2_dcb_dpt_commerce_ceiling_tile_01",(-22309.2, 6091.83, -299.236),(3, 6, 59));
	SpawnModel("com_plasticcase_beige_big",(-21295.3, 6088.88, -299.771),(51, 0, 0));
	SpawnModel("com_plasticcase_beige_big",(-22370.7, 6128.11, -315.763),(0, -69, 0));
	SpawnModel("com_plasticcase_beige_big",(-22371.7, 6124.77, -288.168),(0, -54, 0));
	SpawnModel("com_plasticcase_beige_big",(-22339.5, 6112.71, -259.624),(0, -1, 0));
	SpawnModel("com_plasticcase_beige_big",(-19846.8, 6121.75, -343.384),(7, -9, 0));
	SpawnModel("com_plasticcase_beige_big",(-20016, 6134.88, -337.634),(0, -80, 6));
	SpawnModel("vehicle_m1a1_abrams_static",(-20035.2, 2899, -367.026),(-10, -135, -8));

	level thread CreateWallTeleport4(1,6075,6030);

	level thread createFlag((-21120,4657,-354));
}

Cliffhanger_Models()
{
	PrecacheModel("vehicle_mack_truck_short_snow_destructible");
	PrecacheModel("vehicle_uaz_winter_destructible");
	PrecacheModel("h1_me_armada_concrete_wall_chunk_01_burn_large");
}

Cliffhanger_Edit(){
	level.randomFlagRadiusX = 100;
	level.randomFlagRadiusY = 400;
	SpawnModel("vehicle_mack_truck_short_snow_destructible",(-4227.35, -24465.3, 947.372),(-4, 108, 8));
	SpawnModel("vehicle_uaz_winter_destructible",(-4201.22, -24714.7, 946.796),(0, -33, 0));
	SpawnModel("vehicle_mack_truck_short_snow_destructible",(-4701.4, -27455.3, 924.639),(-16, -6.12676, 3));
	SpawnModel("vehicle_mack_truck_short_snow_destructible",(-5166.8, -27417.5, 889.999),(0, 0, 0));
	SpawnModel("vehicle_mack_truck_short_snow_destructible",(-5514.25, -27420.2, 891.018),(0, -0.0520554, 0));
	SpawnModel("vehicle_mack_truck_short_snow_destructible",(-5765, -27554.6, 892.092),(0, -89, 0));
	SpawnModel("vehicle_uaz_winter_destructible",(-5857.77, -27451.4, 887.406),(0, -90, 0));
	SpawnModel("vehicle_uaz_winter_destructible",(-4207.2, -26987.6, 966.702),(0, 1, 0));
	SpawnModel("vehicle_uaz_winter_destructible",(-4213.96, -27338.9, 1011.73),(-13, -83, 0));
	SpawnModel("vehicle_uaz_winter_destructible",(-4468.72, -27409.8, 999.486),(-15, 6.32307, 0));
	SpawnModel("h1_me_armada_concrete_wall_chunk_01_burn_large",(-4327.11, -27381, 1047.93),(0, -8, -78));

	level thread CreateWallTeleport2(0,-4300,-4336);
	level thread CreateWallTeleport3(1,-27365,-27264);

	level thread createFlag((-5199,-25430,963));
}

Rundown_Models(){
	PrecacheModel("me_corrugated_metal8x8");
	PrecacheModel("me_dumpster");
	PrecacheModel("com_steel_ladder");
	PrecacheModel("vehicle_bm21_mobile_bed_destructible");
	PrecacheModel("vehicle_small_hatch_blue_destructible_mp");
	PrecacheModel("vehicle_small_hatch_white_destructible_mp");
	PrecacheModel("vehicle_uaz_open_destructible");
	PrecacheModel("ch_crate64x64");
	PrecacheModel("ch_crate48x64");
	PrecacheModel("ch_crate32x48");
}

Rundown_Edit(){
	level.randomFlagRadiusX = 100;
	level.randomFlagRadiusY = 200;
	for(i=0;i<(3*60);i+=60)
		CreateWalls((1468.18, -1268, 82+i),(1769.77, -1140, 83+i));
	CreateWalls((1712.78, -1167.43, 255.686),(2234.94, -939.645, 241.149));
	CreateWalls((2444.06, -841.549, 151),(2514.85, -812.292, 152));
	SpawnModel("vehicle_bm21_mobile_bed_destructible",(1668.45, -1267.4, 106.173),(-1, 28, -15));
	SpawnModel("me_corrugated_metal8x8",(2477.59, -827.419, 155.539),(0, 31, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1115.45, -1328, 55+i),(498.347, -1672.73, 56+i));
	SpawnModel("ch_crate64x64",(1137.85, -1386.57, 43.7038),(-12, 38, 0));
	SpawnModel("ch_crate64x64",(1066.63, -1430.32, 34.2233),(0, 31.4923, 0));
	SpawnModel("ch_crate64x64",(1002.74, -1477.56, 30.9241),(0, -29, 0));
	SpawnModel("ch_crate64x64",(833.914, -1567.98, 31.4076),(0, 20.0446, 0));
	SpawnModel("ch_crate64x64",(771.507, -1616.79, 30.5651),(0, -1, 0));
	SpawnModel("ch_crate64x64",(694.813, -1645.64, 31.709),(0, 16.0071, 0));
	SpawnModel("ch_crate64x64",(615.574, -1672.27, 30.8982),(0, 4.97131, 0));
	SpawnModel("ch_crate32x48",(558.683, -1666.55, 30.8518),(0, 9.01428, 0));
	SpawnModel("ch_crate32x48",(557.156, -1667.15, 62.6098),(0, -11.6016, 0));
	SpawnModel("ch_crate32x48",(620.064, -1670.57, 93.9794),(0, 51.7456, 0));
	SpawnModel("ch_crate32x48",(943.888, -1453.6, 30.3955),(0, 78.2172, 0));
	SpawnModel("ch_crate32x48",(943.015, -1460.98, 60.9543),(0, -33.5632, 0));
	SpawnModel("ch_crate32x48",(874.36, -1531.35, 54.9258),(35, 43, -4));
	SpawnModel("ch_crate32x48",(909.392, -1484.83, 119.898),(-10, -39, -166));
	SpawnModel("ch_crate48x64",(1078.8, -1418.46, 98.9463),(0, 113.961, -4));
	SpawnModel("ch_crate48x64",(995.23, -1472.98, 94.1296),(0, -0.620728, 0));
	SpawnModel("ch_crate48x64",(807.368, -1584.46, 94.958),(0, -15, 0));
	SpawnModel("ch_crate48x64",(729.864, -1625.57, 95.1051),(0, -57, 0));
	SpawnModel("ch_crate48x64",(676.104, -1658.13, 94.6946),(0, 48.2245, 0));
	CreateWalls((496.27, -1506.56, 236.122),(426.119, -1574.55, 226.426));
	CreateBlocks((788.525, -1440.2, 262.629),(-176, -151, -4));
	SpawnModel("me_dumpster",(246.259, -1695.65, 21.8744),(0, 49, -4));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((312.474, -1724.19, 28+i),(189.414, -1609.05, 29+i));
	CreateWalls((280.624, -1636.39, 206.254),(356.211, -1674.97, 210.044));
	SpawnModel("vehicle_uaz_open_destructible",(-83.11, -1638.98, 12.4187),(0, 29.6185, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-31.8933, -1564.21, 16+i),(-172.045, -1635.81, 17+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-646.793, -1486.37, 30+i),(-924.269, -1582.59, 31+i));
	SpawnModel("vehicle_bm21_mobile_bed_destructible",(-771.347, -1597.21, 8.79068),(0, 21, 0));
	SpawnModel("ch_crate64x64",(1611.23, 101.767, 10.9576),(0, -52, 0));
	CreateWalls((1576.88, 147.553, 41),(1560.33, 82.0168, 40));
	SpawnModel("vehicle_bm21_mobile_bed_destructible",(1613.32, 616.077, -3.58204),(0, 112, 0));
	SpawnModel("vehicle_small_hatch_blue_destructible_mp",(1486.93, 817.215, -0.520447),(2, -45, -3));
	SpawnModel("vehicle_small_hatch_white_destructible_mp",(1426.74, 883.565, 23.5027),(-26, -43, 2));
	SpawnModel("vehicle_small_hatch_white_destructible_mp",(1542.85, 753.28, 67.0684),(15, 121, -1));
	for(i=0;i<(2*60);i+=60){
		CreateWalls((1351.13, 913.819, 15+i),(1599.31, 455.125, 16+i));
		CreateWalls((-1392.09, -110.748, 134+i),(-1600.56, -123.004, 135+i));
		CreateWalls((-1377.36, -645.303, 41+i),(-1465.06, -592.379, 40+i));
		CreateWalls((-1747.64, 326.686, 41+i),(-1896.26, 400.031, 40+i));
		CreateWalls((-860.679, 1221.13, 41+i),(-660.719, 1170.88, 40+i));
	}
	SpawnModel("me_dumpster",(-1440.95, -640.818, 13.7905),(0, 58, 0));
	SpawnModel("me_dumpster",(-1154.92, -743.061, 17.0927),(0, -39.3699, 0));
	CreateBlocks((-1137.16, -708.983, 58.8536),(0, -21, 0));
	SpawnModel("me_corrugated_metal8x8",(-1798.1, 313.902, 62.1565),(0, -23.4726, 0));
	SpawnModel("me_corrugated_metal8x8",(-1884.21, 356.09, 61.7152),(0, -30.361, 0));
	CreateWalls((-1736.44, 334.121, 204.708),(-1834.78, 431.399, 183.144));
	SpawnModel("me_corrugated_metal8x8",(-842.311, 1249.89, 60.3671),(0, -12, 0));
	SpawnModel("me_corrugated_metal8x8",(-752.703, 1219.93, 59.0668),(0, 158.543, 0));
	SpawnModel("me_corrugated_metal8x8",(-696.576, 1208.16, 59.042),(0, -12, 0));
	SpawnModel("me_corrugated_metal8x8",(295.855, 838.328, 63.2513),(0, -93, 0));
	CreateWalls((307.282, 905.344, 42),(301.434, 795.583, 41));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((-21.961, 1088.52, 25+i),(-283.944, 1144.78, 26+i));
	SpawnModel("me_corrugated_metal8x8",(-241.058, 1115.34, 59.1653),(0, -10, 0));
	SpawnModel("me_corrugated_metal8x8",(-150.11, 1099.61, 56.9367),(0, -8, 0));
	SpawnModel("me_corrugated_metal8x8",(-56.2066, 1083.98, 56.8133),(0, -13, 0));
	SpawnModel("me_corrugated_metal8x8",(566.855, 1171.9, 103.902),(0, 226.301, 0));
	SpawnModel("me_corrugated_metal8x8",(637.506, 1235.56, 121.527),(0, 217.188, 0));
	SpawnModel("me_corrugated_metal8x8",(687.669, 1310.21, 141.044),(0, -107, 0));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((729.673, 1344.88, 57+i),(551.847, 1127.01, 56+i));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((1327.05, 956.324, 19+i),(1012.39, 1344.88, 20+i));
	SpawnModel("vehicle_bm21_mobile_bed_destructible",(1268.83, 1101.05, 12.8238),(0, -52, 0));
	SpawnModel("vehicle_small_hatch_white_destructible_mp",(1137.95, 1277.31, 26.044),(0, -131, -17));
	SpawnModel("vehicle_small_hatch_blue_destructible_mp",(1051.87, 1395.75, 64.7361),(-11, 96.7072, 0));
	SpawnModel("me_corrugated_metal8x8",(828.01, 1366.06, 243.986),(0, -1, 0));
	CreateAsc((996, 252, 10),(996, 252, 250),180,4);
	for(i=0;i<(2*60);i+=60)
		CreateWalls((974, 340, 231+i),(702, 340, 232+i));
	SpawnModel("me_corrugated_metal8x8",(919.566, 324.412, 263.972),(0, 0, 0));
	SpawnModel("me_corrugated_metal8x8",(826.362, 324.124, 264.391),(0, 0, 0));
	SpawnModel("me_corrugated_metal8x8",(753.952, 323.2, 263.77),(0, 0, 0));
	CreateBlocks((1473.33, 121.961, 169.502),(0, 90.3461, 0));
	CreateAsc((1125, -571, 12),(1125, -571, 145),0,4);
	SpawnModel("me_corrugated_metal8x8",(-210.568, -1601.45, 204.326),(0, -62, 0));
	SpawnModel("me_corrugated_metal8x8",(-141.407, -1626.44, 233.866),(0, 28, 0));
	SpawnModel("me_corrugated_metal8x8",(-58.9029, -1582.03, 234.076),(0, 27, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-9.64431, -1577.03, 178+i),(-168.207, -1651.77, 179+i));
	CreateWalls((-258.205, -1555.24, 200),(-203.548, -1658.03, 201));
	CreateBlocks((-309.628, -1453.54, 233.498),(-87, -46, -14));
	SpawnModel("me_corrugated_metal8x8",(-297.347, -1446.5, 237.684),(0, -62, 0));
	level thread createFlag((429,-150,15));
}

Estate_Models(){
	PrecacheModel("com_steel_ladder");
	PrecacheModel("me_corrugated_metal8x8");
}

Estate_Edit(){
	level.randomFlagRadiusX = 75;
	level.randomFlagRadiusY = 300;
	SpawnModel("com_steel_ladder",(572.216, 1103.56, 369.448),(0, 74, 0));
	level thread CreateTeleport((574, 1119, 190),(571, 1086, 322), "ladder");
	SpawnModel("me_corrugated_metal8x8",(-816.223, 955.836, 81.8184),(28, 56, -4));
	SpawnModel("me_corrugated_metal8x8",(-778.13, 1025.51, 13.1884),(-43, 244.94, 0));
	SpawnModel("me_corrugated_metal8x8",(-741.808, 1084.27, -60.4463),(-40, 242.507, 0));
	SpawnModel("me_corrugated_metal8x8",(-716.615, 1135.03, -124.392),(-23, 232.817, 0));
	SpawnModel("me_corrugated_metal8x8",(-677.613, 1193.89, -144.965),(7, 230.483, -3));
	SpawnModel("me_corrugated_metal8x8",(-626.354, 1275.02, -126.771),(-8, 61.7843, -3));
	SpawnModel("me_corrugated_metal8x8",(-568.546, 1359.4, -91.3068),(-27, 46, 0));
	SpawnModel("me_corrugated_metal8x8",(-528, 1428.93, -37.0402),(-25, 66.519, 0));
	SpawnModel("me_corrugated_metal8x8",(-180.531, 1486.75, 145.227),(18, 150.142, 0));
	SpawnModel("me_corrugated_metal8x8",(-267.032, 1500.33, 100.483),(21, 177.739, 0));
	SpawnModel("me_corrugated_metal8x8",(-354.18, 1494.94, 72.8574),(-8, 12.1365, -2));
	SpawnModel("me_corrugated_metal8x8",(-442.263, 1464.75, 50.5164),(10, 200.479, 0));
	SpawnModel("me_corrugated_metal8x8",(-485.556, 1441.35, 11.5692),(14, 205.23, -3));
	SpawnModel("me_corrugated_metal8x8",(-128.173, 1500.28, 165.016),(0, 83.6263, -5));
	SpawnModel("me_corrugated_metal8x8",(-68.6488, 1540.51, 173.239),(0, -11, 0));
	SpawnModel("me_corrugated_metal8x8",(-6.66368, 1577.71, 177.032),(0, 73, 0));
	SpawnModel("me_corrugated_metal8x8",(52.6105, 1626.37, 176.691),(0, -1, 0));
	SpawnModel("me_corrugated_metal8x8",(148.39, 1616.44, 177.236),(0, -3, 0));
	SpawnModel("me_corrugated_metal8x8",(242.316, 1626.13, 168.41),(9, 9.01282, -5));
	SpawnModel("me_corrugated_metal8x8",(320.462, 1661.28, 155.749),(0, 27, 0));
	SpawnModel("me_corrugated_metal8x8",(400.5, 1701.24, 148.751),(0, 209.52, 0));
	SpawnModel("me_corrugated_metal8x8",(477.562, 1742, 152.432),(0, 33, 0));
	SpawnModel("me_corrugated_metal8x8",(553.246, 1783.33, 152.491),(0, 207.971, 0));
	SpawnModel("me_corrugated_metal8x8",(591.697, 1854.06, 164.898),(0, 89, 0));
	SpawnModel("me_corrugated_metal8x8",(592.657, 1939.23, 177.108),(0, 92, 0));
	SpawnModel("me_corrugated_metal8x8",(-819.03, 136.125, 79.2885),(0, -36, 0));
	SpawnModel("me_corrugated_metal8x8",(308.589, -511.579, 111.39),(0, -20, 0));
	SpawnModel("me_corrugated_metal8x8",(398.431, -546.277, 111.579),(0, -20, 0));
	SpawnModel("me_corrugated_metal8x8",(902.411, -452.181, 91.2441),(0, -11.0522, 0));
	SpawnModel("me_corrugated_metal8x8",(990.861, -480.608, 92.0081),(0, -19.704, 0));
	SpawnModel("me_corrugated_metal8x8",(1344.84, 96.8026, 71.4456),(0, 77, 0));
	SpawnModel("me_corrugated_metal8x8",(1409.89, 322.145, 83.9868),(0, 69, 0));
	SpawnModel("me_corrugated_metal8x8",(1417.5, 291.546, 78.9646),(0, 47.7905, 0));
	SpawnModel("me_corrugated_metal8x8",(926.256, 1942.8, 167.984),(0, 182.411, 0));
	SpawnModel("me_corrugated_metal8x8",(1019.7, 1949.78, 167.541),(0, 181.791, 0));
	SpawnModel("me_corrugated_metal8x8",(1098.34, 1943.26, 168.235),(0, -10, 0));
	for(i=0;i<(3*60);i+=60){
		CreateWalls((802.711, 1935.64, 141+i),(1207.28, 1925.46, 142+i));
		CreateWalls((594.608, 1935.62, 137+i),(588.539, 1784.87, 136+i));
		CreateWalls((558.483, 1775.01, 113+i),(207.409, 1608.68, 114+i));
		CreateWalls((181.23, 1609.27, 131+i),(10.2002, 1608.47, 132+i));
		CreateWalls((4.13419, 1603.52, 131+i),(-21.7923, 1533.47, 132+i));
		CreateWalls((-29.4333, 1532.23, 131+i),(-129.232, 1549.88, 132+i));
		CreateWalls((-129.232, 1549.88, 132+i),(-126.4333, 1461.23, 131+i));
		CreateWalls((-126.4333, 1461.23, 82+i),(-224.4333, 1510.23, 83+i));
		CreateWalls((-224.4333, 1510.23, 83+i),(-328.4333, 1520.23, 82+i));
		CreateWalls((-757.935, 1037.47, -179+i),(-541.812, 1378.59, -178+i));
	}
	for(i=0;i<(4*60);i+=60){
		CreateWalls((-328.4333, 1520.23, -21+i),(-493.68, 1453.32, -20+i));
		CreateWalls((-516.225, 1424.58, -21+i),(-831.203, 916.125, -20+i));
	}
	CreateBlocks((-513.089, 1399.93, -54.2047),(53, -81, -7));
	SpawnModel("me_corrugated_metal8x8",(-719.757, 143.649, 73.4059),(0, -14, 0));
	SpawnModel("me_corrugated_metal8x8",(-633.323, 124.024, 78.5053),(0, -9, 0));
	SpawnModel("me_corrugated_metal8x8",(-546.829, 103.508, 83.2684),(0, -16, 0));
	SpawnModel("me_corrugated_metal8x8",(-473.447, 80.3267, 82.5647),(0, -25, 0));
	SpawnModel("me_corrugated_metal8x8",(-448.442, 16.1531, 82.4989),(0, 253.449, 0));
	SpawnModel("me_corrugated_metal8x8",(-480.001, -74.2448, 85.8333),(0, 248.472, 0));
	SpawnModel("me_corrugated_metal8x8",(-782.766, 111.041, 70.5534),(0, -108, 0));
	for(i=0;i<(3*60);i+=60){
		CreateWalls((-836.375, 155.86, 39+i),(-429.933, 70.0511, 40+i));
		CreateWalls((-429.933, 70.0511, 39+i),(-493.933, -114.0511, 40+i));
		CreateWalls((209.141, -497.489, 74+i),(513.241, -584.868, 73+i));
		CreateWalls((513.241, -584.868, 73+i),(638.241, -532.868, 74+i));
		CreateWalls((638.241, -532.868, 73+i),(727.241, -445.868, 74+i));
		CreateWalls((727.241, -445.868, 73+i),(1135.241, -517.868, 74+i));
		CreateWalls((1135.241, -517.868, 74+i),(1515.241, 622.868, 73+i));
	}
	CreateWalls((184.551, -486.757, 123.229),(-333.616, -334.621, 116.56));
	level thread createFlag((306,1027,190));
}

Seatown_Models(){
	PrecacheModel("ch_crate48x64");
	PrecacheModel("ch_crate24x36");
	PrecacheModel("ch_crate32x48");
	PrecacheModel("com_pallet_stack");
}

Skidrow_Models(){
	PrecacheModel("me_dumpster");
	PrecacheModel("me_dumpster_close");
	PrecacheModel("me_corrugated_metal4x8");
	PrecacheModel("me_corrugated_metal2x8");
	PrecacheModel("me_concrete_barrier");
}

Underpass_Models(){
	PrecacheModel("com_folding_table");
	PrecacheModel("me_corrugated_metal8x8");
	PrecacheModel("me_dumpster");
	PrecacheModel("me_dumpster_close");
	PrecacheModel("com_steel_ladder");
	PrecacheModel("vehicle_pickup_destructible_mp");
	PrecacheModel("vehicle_van_slate_destructible");
	PrecacheModel("ch_crate64x64");
	PrecacheModel("ch_crate48x64");
	PrecacheModel("ch_crate32x48");
}

Underpass_Edit(){
	SpawnModel("me_dumpster",(1957.58, 679.743, 447.847),(0, -8, 0));
	SpawnModel("me_dumpster",(1949.15, 778.468, 427.334),(-1, -98, -30));
	SpawnModel("me_dumpster",(2043.22, 1776.99, 343.223),(0, -1, -38));
	SpawnModel("ch_crate32x48",(2045.3, 1759.44, 404.991),(22, -86, 1));
	SpawnModel("vehicle_pickup_destructible_mp",(2063.73, 2060.03, 287.113),(7, 97.2475, -3));
	SpawnModel("ch_crate64x64",(2075.13, 2003.73, 340.056),(0, 89.6834, -7));
	SpawnModel("com_folding_table",(2038.47, 1897.02, 335.807),(-316, -8, 1));
	SpawnModel("vehicle_van_slate_destructible",(1152.58, 2185.07, 382.253),(0, 176.082, 0));
	SpawnModel("me_corrugated_metal8x8",(1162.27, 2147.45, 429.603),(0.00978813, -3, -204.212));
	SpawnModel("ch_crate32x48",(1070.35, 2186.44, 427.615),(0, -91, 9));
	SpawnModel("com_folding_table",(1098.18, 2118.59, 383.284),(0, -89, 0));
	SpawnModel("com_steel_ladder",(1263.79, 2101.89, 452.838),(-280, -41, -37));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1020.66, 2091.44, 400+i),(1300, 2078.73, 401+i));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((2017.96, 2152.87, 300+i),(2011.96, 1747.13, 301+i));
	CreateVisableRamps((-215.761, 2415.98, 280.125),(-381.389, 2418.82, 360.511));
	SpawnModel("ch_crate64x64",(-505.913, 2590.1, 353.275),(0, 175.464, 0));
	SpawnModel("ch_crate64x64",(-437.331, 2581.84, 352.619),(0, -95, 0));
	SpawnModel("ch_crate64x64",(-464.748, 2599.77, 416.298),(0, 173.338, 0));
	for(i=0;i<(2*60);i+=60)
	CreateWalls((-528.875, 2547, 368+i),(-415.14, 2547, 369+i));
	SpawnModel("me_dumpster_close",(11.7062, 2798.95, 247.171),(0, -135, 0));
	SpawnModel("me_dumpster_close",(-69.1686, 2858.39, 249.639),(-2, 171.305, -2));
	SpawnModel("me_dumpster_close",(-156.104, 2842.03, 253.119),(0, -94, 0));
	SpawnModel("me_corrugated_metal8x8",(-155.987, 2858.27, 319.568),(0.420181, -4.98303, -79.8385));
	SpawnModel("ch_crate48x64",(22.406, 2804.51, 311.643),(-6, -1, 8));
	for(i=0;i<(2*60);i+=60){
		CreateWalls((24.6051, 2759.13, 285+i),(-52.7726, 2817.33, 286+i));
		CreateWalls((-95.1824, 2815.43, 285+i),(-192.875, 2817.42, 286+i));
	}
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1910.18, 816.875, 487+i),(1906.71, 647.125, 488+i));
	SpawnModel("com_steel_ladder",(1108.98, 206.42, 552.5),(0, 89, 0));
	level thread CreateTeleport((1108, 232, 383),(1104, 183, 512), "ladder");
	level thread CreateTeleport((1104, 183, 512),(1108, 232, 383), "ladder");
	SpawnModel("ch_crate48x64",(180.972, 1462.47, 520.322),(0, -84, 0));
	SpawnModel("ch_crate48x64",(-56.7573, 1441.64, 520.199),(0, -121, 0));
	CreateViewableBlocks((180.632, 1460.17, 551.858),(0, 7, 0));
	CreateViewableBlocks((-57.6928, 1440.41, 550.987),(0.0826673, -29, -0.040974));
	SpawnModel("vehicle_pickup_destructible_mp",(1894.06, 278.758, 454.819),(0, 34.48, 0));
	SpawnModel("vehicle_van_slate_destructible",(1673.04, 146.997, 454.451),(0, 34.7876, 0));
	SpawnModel("ch_crate48x64",(1676.2, 230.038, 454.002),(0, 0, 0));
	SpawnModel("ch_crate32x48",(1675.74, 223.888, 501.377),(0, -48, 0));
	SpawnModel("me_dumpster",(1871.08, 365.952, 456.291),(0, -241, 0));
	SpawnModel("com_folding_table",(1791.08, 328.97, 491.881),(-1, -48, -90));
	SpawnModel("ch_crate32x48",(1813.98, 327.399, 480.777),(0, 41.9507, -92));
	SpawnModel("ch_crate32x48",(1606.81, 209.341, 454.786),(0, -40, 0));
	SpawnModel("ch_crate32x48",(1602.97, 220.431, 486.896),(0, 25.5316, 0));
	SpawnModel("me_dumpster_close",(1425.83, 107.68, 445.965),(0, -58, 12));
	SpawnModel("me_dumpster_close",(1314.78, 53.8389, 443.717),(0, -28, 0));
	SpawnModel("me_corrugated_metal8x8",(2017.17, 484.08, 492.412),(359.998, -130, -180.232));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2000.76, 514.635, 472+i),(1271.13, 95.1762, 473+i));
	SpawnModel("ch_crate64x64",(1278.11, -233.296, 511.322),(0, 0, 0));
	SpawnModel("ch_crate64x64",(1277.67, -232.171, 571.604),(0, 0, 0));
	SpawnModel("ch_crate48x64",(1289.63, 358.61, 433.025),(-8, -42, 17));
	SpawnModel("ch_crate48x64",(1532.32, 564.037, 407.004),(-12, -34, 4));
	CreateBlocks((1262.85, -233.063, 563.081),(270, 360, 0.00308476));
	CreateViewableBlocks((1282.7, 352.5, 463.63),(16.5811, -128, 9.82003));
	CreateViewableBlocks((1526.41, 565.661, 437.853),(-4.25167, 54, -13.1485));
	SpawnModel("me_dumpster_close",(572.078, -389.045, 368.959),(-21, 0, 7));
	SpawnModel("ch_crate32x48",(560.644, -398.406, 428.989),(-12, -3, 8));
	SpawnModel("com_folding_table",(546.931, -368.526, 406.829),(-17, -22, -84));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((519.509, -440.875, 360+i),(527.567, -330.98, 361+i));
	for(i=0;i<(4*60);i+=60)
		CreateWalls((-564.006, -127.125, 609+i),(-556.505, -258.44, 608+i));
	SpawnModel("com_steel_ladder",(176.225, -198.152, 595),(0, 0, 0));
	level thread CreateTeleport((191, -198, 320),(183, -199, 626), "ladder");
	for(i=0;i<(3*60);i+=60)
		CreateWalls((356.838, 140.875, 670+i),(357.319, -320.371, 671+i));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((386.957, 146.458, 670+i),(582.24, 146.255, 671+i));
	CreateBlocks((-551.468, 429.383, 608.794),(359.982, -5, 1.31918));
	CreateVisableRamps((-421, 1245, 340),(-421, 434, 590));
	offset=48;
	CreateWoodRamps((-421, 1245, 340-offset),(-421, 434, 590-offset));
	SpawnModel("com_steel_ladder",(180.82, 1679.71, 508.146),(0, 89, 0));
	level thread CreateTeleport((179, 1695, 384),(178, 1677, 523), "ladder");

	level.randomFlagRadiusX = 350;
	level.randomFlagRadiusY = 250;
	level thread createFlag((596,784,156));
}
Seatown_Edit(){
	SpawnModel("ch_crate48x64",(-1053.51, 707, 302.053),(0, -85, 0));
	SpawnModel("ch_crate48x64",(-1128.68, 704, 300.466),(0, -86, 0));
	SpawnModel("ch_crate48x64",(-1106.21, 704, 349.159),(0, -93, 2));
	SpawnModel("ch_crate24x36",(-1050.25, 710, 348.176),(0.0221057, -36, -0.0281302));
	CreateWalls((-1149.47, 680, 330),(-1015.72, 696, 331));

	SpawnModel("ch_crate48x64",(-1330.94, 583.889, 167.097),(0, -50, 0));
	SpawnModel("ch_crate48x64",(-1392.4, 543.057, 167.301),(0, -66, 0));
	SpawnModel("ch_crate48x64",(-1453.72, 496.098, 167.422),(0, 140, 0));
	SpawnModel("ch_crate32x48",(-1494.37, 458.012, 166.644),(0, 49, 0));
	SpawnModel("ch_crate32x48",(-1466.18, 502.278, 213.874),(0, 186.774, 0));
	SpawnModel("ch_crate32x48",(-1391.65, 548.018, 213.787),(0, 224.902, 0));
	SpawnModel("ch_crate32x48",(-1424.69, 514.416, 213.855),(0, -15, 0));
	SpawnModel("ch_crate32x48",(-1338.16, 586.689, 213.542),(0, -5, 0));
	SpawnModel("ch_crate32x48",(-1510.4, 458.119, 225.251),(0, 253.947, -94));
	CreateWalls((-1266.13, 601.871, 200),(-1490.83, 435.125, 201));
	CreateBlocks((-1548.78, 358.667, 220.402),(359.993, 359.998, 0));
	CreateWalls((-1258.46, 566.626, 353),(-1468.53, 394.569, 354));
	CreateBlocks((-1285.97, 563.168, 278.765),(359.944, 32, 0.405712));

	SpawnModel("com_pallet_stack",(-1680.03, 51.2568, 168.597),(0, -75, 0));
	SpawnModel("com_pallet_stack",(-1690.3, 119.913, 169.476),(0, 18, 0));
	SpawnModel("com_pallet_stack",(-1689.27, 61.4586, 201.977),(0, 255.462, 0));
	SpawnModel("com_pallet_stack",(-1694.21, 125.989, 201.301),(0, -13, 0));
	SpawnModel("ch_crate32x48",(-1689.88, 65.4585, 232.522),(0, -6, 0));
	SpawnModel("ch_crate32x48",(-1694.86, 125.996, 233.362),(0, 229.199, 0));
	CreateWalls((-1645.98, 26.8257, 200.722),(-1645.46, 144.294, 201.125));

	CreateViewableBlocks((-350.204, -1230.85, 209.532),(359.638, -90, -0.045681));
	CreateViewableBlocks((-350.204, -1162.85, 209.532),(359.638, -90, -0.045681));
	SpawnModel("ch_crate48x64",(-364.475, -1262.17, 184.727),(-2, -88, 0));

	SpawnModel("ch_crate32x48",(-355.325, -1203.51, 198.295),(0, 1, 0));
	SpawnModel("ch_crate32x48",(-352.747, -1156.02, 197.041),(0, 0, 0));

	SpawnModel("ch_crate48x64",(-73.9217, -1265.22, 200.351),(0, -88, 0));
	SpawnModel("ch_crate48x64",(-140.727, -1279.05, 197.944),(0, -94, 0));
	SpawnModel("ch_crate48x64",(-201.255, -1279.99, 196.677),(0, 2, 0));
	SpawnModel("ch_crate48x64",(-302.048, -1269.73, 195.858),(0, -92, 0));
	SpawnModel("ch_crate32x48",(-248.945, -1273.73, 197.956),(0, -9, 0));
	SpawnModel("ch_crate32x48",(-248.225, -1273.44, 230.069),(0, -14.9667, 0));
	SpawnModel("com_pallet_stack",(-189.674, -1284.98, 244.621),(-3, -7.97386, -1));
	SpawnModel("com_pallet_stack",(-104.285, -1275.01, 246.999),(0, 10, 0));
	SpawnModel("ch_crate48x64",(-302.898, -1268.6, 243.816),(0, -109, 0));
	CreateWalls((-48.125, -1245.78, 233),(-334.25, -1245.28, 232));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-48.179, -1245.8, 300+i),(-615.038, -1245, 301+i));

	SpawnModel("ch_crate48x64",(-1738.82, -949.524, 151.751),(0, 32, 0));
	SpawnModel("ch_crate48x64",(-1700.72, -1009.88, 153.087),(0, 32, 0));
	SpawnModel("ch_crate48x64",(-1659.54, -1067.82, 151.159),(0, 32, 0));
	SpawnModel("ch_crate48x64",(-1630.22, -1135.95, 149.358),(0, 10, 0));
	SpawnModel("ch_crate48x64",(-1590.93, -1204.05, 149.158),(0, 38, 0));
	SpawnModel("ch_crate48x64",(-1507.74, -1195.16, 150.46),(0, -87, 0));
	SpawnModel("ch_crate48x64",(-1322.7, -1200.03, 149.365),(0, -89, 0));
	SpawnModel("ch_crate48x64",(-1252.36, -1193.02, 153.689),(0, -86, 0));
	SpawnModel("ch_crate48x64",(-1183.1, -1195.7, 150.787),(0, -91, 0));
	SpawnModel("ch_crate48x64",(-1115.22, -1201.37, 148.504),(0, -94, 0));
	SpawnModel("ch_crate48x64",(-1042.83, -1210.96, 150.992),(0, -104, 0));
	SpawnModel("ch_crate48x64",(-955.348, -1221.42, 149.787),(0, -97, 0));
	SpawnModel("ch_crate48x64",(-884.522, -1230.09, 152.369),(0, -99, 0));
	SpawnModel("ch_crate48x64",(-824.307, -1246.64, 151.248),(0, -8.21228, 0));
	SpawnModel("ch_crate48x64",(-758.934, -1243.31, 149.621),(0, -94, 0));
	SpawnModel("ch_crate48x64",(-689.384, -1247.37, 150.761),(0, 90, 0));
	SpawnModel("ch_crate48x64",(-631.109, -1266.09, 150.091),(0, -10.025, 0));
	SpawnModel("ch_crate48x64",(-1729.55, -983.836, 199.76),(0, -9, 0));
	SpawnModel("ch_crate48x64",(-1676.32, -1057.57, 199.433),(1, 22, 3));
	SpawnModel("ch_crate48x64",(-1611.38, -1166.28, 197.101),(0, 37, -1));
	SpawnModel("ch_crate48x64",(-1536.64, -1199.85, 197.442),(0, -78, 1));
	SpawnModel("ch_crate24x36",(-1464.85, -1191.77, 151.24),(1.20816, 0.316236, -1.21551));
	SpawnModel("ch_crate24x36",(-1457.66, -1192.46, 174.082),(359.372, -10, -0.0462852));
	SpawnModel("ch_crate32x48",(-1472.79, -1197.95, 197.337),(0, 29, 0));
	SpawnModel("ch_crate48x64",(-1290.42, -1193.76, 200.203),(0, 94, -7));
	SpawnModel("ch_crate48x64",(-1215.13, -1193.14, 200.665),(0, -88, -5));
	SpawnModel("ch_crate48x64",(-1141.54, -1198, 198.268),(0, -86, -3));
	SpawnModel("ch_crate48x64",(-653.096, -1251.16, 197.825),(0, -92, 0));
	SpawnModel("ch_crate48x64",(-729.991, -1252.09, 196.307),(0, 77, 0));
	SpawnModel("ch_crate48x64",(-801.291, -1246.58, 196.792),(0, 84, 0));
	SpawnModel("ch_crate48x64",(-859.114, -1251.48, 198.531),(0, -3, 0));
	SpawnModel("ch_crate48x64",(-921.99, -1232.04, 199.43),(0, 74, -3));
	SpawnModel("ch_crate48x64",(-1070.9, -1207.09, 198.353),(-1, 80, -3));
	SpawnModel("ch_crate32x48",(-977.284, -1222.21, 198.12),(1, -1, -1));
	SpawnModel("ch_crate24x24",(-1027.09, -1212.69, 198.442),(0, -101.416, 0));
	SpawnModel("ch_crate48x64",(-1361.65, -1210.3, 194.747),(0, -92, 13));
	SpawnModel("ch_crate32x48",(-1421.08, -1209.92, 192.98),(0, -91, 11));
	SpawnModel("ch_crate32x48",(-1641.67, -1110.15, 198.476),(0, -4, 0));
	SpawnModel("ch_crate32x48",(-1741.19, -934.203, 199.868),(0, 82, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-618.125, -1240.15, 180+i),(-1223.75, -1178.52, 181+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-1223.75, -1172.52, 180+i),(-1580.33, -1174.21, 181+i));
	CreateWalls((-1580.33, -1174.21, 180),(-1725.75, -914.125, 181));
	CreateWalls((-1074.83, -1124.95, 386.324),(-786.763, -1155.2, 390.618));

	SpawnModel("com_pallet_stack",(557.155, -841.773, 208.688),(0, 88.0896, 0));
	SpawnModel("com_pallet_stack",(563.777, -839.57, 240.241),(0, -48, 0));
	SpawnModel("com_pallet_stack",(551.971, -984.907, 207.934),(0, -32, 0));
	SpawnModel("com_pallet_stack",(554.726, -982.533, 239.814),(0, 0, 0));
	SpawnModel("com_pallet_stack",(560.388, -1128.92, 207.79),(0, -26, 0));
	SpawnModel("com_pallet_stack",(562.637, -1128.27, 240.013),(0, 18, 0));
	SpawnModel("com_pallet_stack",(461.499, -1217.81, 208.244),(0, 2.25896, 0));
	SpawnModel("com_pallet_stack",(463.511, -1219.35, 240.079),(0, -21, 0));
	SpawnModel("com_pallet_stack",(316.607, -1218.87, 207.375),(0, -21, 0));
	SpawnModel("com_pallet_stack",(317.212, -1217.63, 239.181),(0, -17.5274, 0));

	CreateWalls((540.66, -801.586, 233),(532.973, -1196.11, 234));
	CreateWalls((545.486, -1212.66, 233),(271.022, -1200.68, 234));
	CreateBlocks((-609.91, -1206.74, 352.069),(266.674, 359.832, -0.874574));

	SpawnModel("ch_crate48x64",(539.849, -426.095, 168.752),(0, 4, 0));
	SpawnModel("ch_crate32x48",(546.535, -371.408, 166.913),(0, 93.9331, 0));
	SpawnModel("ch_crate32x48",(545.282, -366.979, 199.498),(0, -68, 0));
	SpawnModel("ch_crate32x48",(550.262, -426.476, 215.404),(0, -8, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((519.082, -454.03, 202+i),(522.455, -339.717, 201+i));

	SpawnModel("ch_crate48x64",(220.938, 297.823, 207.859),(0, 11, 0));
	SpawnModel("ch_crate48x64",(225.408, 221.133, 208.011),(0, -14, 0));
	SpawnModel("ch_crate48x64",(228.02, 215.642, 255.947),(0, -9, 0));
	SpawnModel("ch_crate48x64",(227.018, 288.738, 256.455),(0, 237.394, 0));
	SpawnModel("ch_crate48x64",(214.565, 488.28, 349.191),(0, 0, 0));
	SpawnModel("ch_crate48x64",(216.172, 488.774, 394.106),(0, 0, 0));
	SpawnModel("ch_crate48x64",(-44.4323, 642.627, 320.259),(0, -80, 0));
	SpawnModel("ch_crate48x64",(26.9672, 647.841, 318.893),(0, -93, 0));
	SpawnModel("ch_crate48x64",(88.7558, 660.322, 316.072),(0, 170.729, 0));
	SpawnModel("ch_crate48x64",(-21.671, 645.499, 368.224),(0, -78, 0));
	SpawnModel("ch_crate48x64",(56.1546, 649.797, 366.013),(0, -94, -5));
	CreateWalls((-55.8748, 635.383, 350.384),(116.559, 637.944, 351.901));
	CreateBlocks((199.729, 489.399, 392.46),(273, 0, 1));
	CreateBlocks((64.5127, 288.059, 375.074),(0.0335479, 66.738, -89.967));
	CreateWalls((176.478, 316.819, 239.496),(181.349, 183.125, 238.917));
	SpawnModel("ch_crate32x48",(-311.007, 648.992, 166.31),(0, 5, 0));
	SpawnModel("ch_crate32x48",(-317.729, 691.39, 168.367),(0, -83.4675, 0));
	SpawnModel("ch_crate32x48",(-319.03, 641.47, 196.992),(0, -86, 0));
	SpawnModel("ch_crate32x48",(-311.598, 682.913, 200.207),(0, 8, 1));
	SpawnModel("ch_crate32x48",(-313.284, 667.432, 231.246),(0, -7, 6));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-303.981, 617.625, 195+i),(-309.172, 712.422, 196+i));

	SpawnModel("ch_crate48x64",(-714.735, 605.672, 166.484),(0, -89, 0));
	SpawnModel("ch_crate48x64",(-648.264, 608.478, 165.887),(0, -89, 0));
	SpawnModel("ch_crate48x64",(-650.926, 613.995, 214.391),(0, -64, 0));
	SpawnModel("ch_crate48x64",(-716.787, 627.877, 212.425),(0, -27, 0));
	CreateWalls((-743.262, 594.723, 195.093),(-626.711, 588.574, 196.522));
	CreateBlocks((-584.305, 559.456, 395.206),(0, 360, 0.00217435));
	CreateWalls((-802.308, -1155.4, 307.094),(-1075.38, -1125.55, 313.557));
	CreateWalls((-1117.89, -1026.63, 390.787),(-1206.62, -1016.53, 391.002));
	level.randomFlagRadiusX = 100;
	level.randomFlagRadiusY = 100;
	level thread createFlag((-659,-203,160));
}

Dome_Edit(){
	level.randomFlagRadiusX = 350;
	level.randomFlagRadiusY = 100;
	level thread createFlag((354,1123,-315));
}

Skidrow_Edit(){
	for(i=0;i<(2*60);i+=60)
		CreateWalls((519.867, -991.125, 6+i),(500.921, -1984.88, 5+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((197.315, -248.875, 37+i),(218.301, 377.374, 38+i));
	//for(i=0;i<(2*60);i+=60)
	//	CreateWalls((-2121.9, -1304.88, 70+i),(-2121.81, -1206.96, 71+i));

	//CreateBlocks((-2134.55, 209.052, 63.7432),(275, 3, 0.00536386));
	SpawnModel("me_dumpster_close",(256.764, 223.665, -1.78966),(0, -180, 0));
	SpawnModel("me_dumpster_close",(266.213, 119.016, -1.7882),(0, -7, 0));
	SpawnModel("me_dumpster_close",(277.533, 18.7564, -0.630417),(0, 10, 0));
	SpawnModel("me_dumpster_close",(266.215, -117.297, 6.90384),(0, -6, 0));
	SpawnModel("me_dumpster_close",(538.728, -1048.99, -6.05187),(-3, 176, -5));
	SpawnModel("me_dumpster_close",(549.979, -1163.29, -8.92422),(0, -8, 0));
	SpawnModel("me_dumpster_close",(559.735, -1268.53, -8.33532),(0, 146, 0));
	SpawnModel("me_dumpster_close",(531.253, -1463.23, -9.42904),(0, -1, 0));
	SpawnModel("me_dumpster_close",(533.345, -1573.13, -8.82674),(0, -178, 0));
	SpawnModel("me_dumpster_close",(534.749, -1686.99, -10.1284),(0, 0, 0));
	SpawnModel("me_dumpster_close",(528.678, -1921.99, -1.72196),(0, -187, 0));
	//SpawnModel("me_corrugated_metal4x8",(-2148.74, 211.97, 65.3479),(-90.9165, 4, -94.0776));
	//SpawnModel("me_dumpster_close",(-2154.21, -1265.04, 39.6254),(0, -2, 0));
	level thread createFlag((-1540,-765,-7));
}

Karachi_Models(){
	PrecacheModel("utility_checkpoint_gate_up");
	PrecacheModel("me_dumpster");
	PrecacheModel("me_dumpster_close");
	PrecacheModel("me_corrugated_metal4x8");
	PrecacheModel("me_corrugated_metal2x8");
	PrecacheModel("me_concrete_barrier");
}

Karachi_Edit(){
	level.randomFlagRadiusX = 50;
	level.randomFlagRadiusY = 300;
	SpawnModel("me_dumpster",(-891.546, 491.425, 1.92868),(-1, -92, -7));
	SpawnModel("utility_checkpoint_gate_up",(-667.037, 453.521, -1.71322),(0, -180, 0));
	SpawnModel("me_concrete_barrier",(-801.009, 469.913, -6.0009),(0, -10, 0));
	SpawnModel("me_concrete_barrier",(-723.029, 462.904, -2.78623),(0, 186.482, 0));
	SpawnModel("me_dumpster_close",(-613.739, 491.133, 7.46698),(0, 181.208, 0));
	SpawnModel("me_dumpster_close",(365.753, 455.832, 30.9488),(-13, -98, -5));
	SpawnModel("me_dumpster_close",(472.872, 487.519, 32.0628),(10, 202.378, 11));
	SpawnModel("me_corrugated_metal4x8",(422.592, 452.665, 76.0751),(0, 83.3493, -12));
	SpawnModel("me_corrugated_metal4x8",(348.123, 436.634, 82.1354),(357.307, 353.175, -24.2855));
	SpawnModel("me_corrugated_metal2x8",(496.909, 445.152, 73.536),(-3, 21.3126, -20));
	SpawnModel("me_corrugated_metal4x8",(292.061, 468.956, 222.491),(269.995, 20, -99.2302));
	SpawnModel("me_corrugated_metal4x8",(293.082, 469.725, 268.708),(-88.8882, 10, -90.0845));
	SpawnModel("me_corrugated_metal4x8",(302.46, 410.691, 245.796),(357.993, -75.6922, -181.03));
	SpawnModel("me_concrete_barrier",(687.949, 417.038, 145.155),(0, -6, 0));
	SpawnModel("me_concrete_barrier",(565.001, 405.836, 141.974),(0, 183.062, 0));
	SpawnModel("me_corrugated_metal4x8",(633.422, 403.778, 168.624),(73.7952, -85, 87.3849));
	SpawnModel("me_corrugated_metal4x8",(1225.53, 26.6912, 168.193),(-90, -80, -98.2816));
	SpawnModel("me_corrugated_metal4x8",(1227.75, 29.1123, 220.642),(-90, -80, -98.2816));
	SpawnModel("me_dumpster_close",(893.419, 175.63, 7.57955),(0, -92, 0));
	SpawnModel("me_dumpster",(1020.81, 193.051, 6.68108),(0, 88, 0));
	SpawnModel("me_dumpster",(1139.2, 192.753, 6.6741),(0, -69, 0));
	SpawnModel("me_corrugated_metal2x8",(996.478, 158.06, 42.7103),(2.63458, 0, 170.325));
	SpawnModel("me_corrugated_metal2x8",(891.97, 176.916, 73.0892),(369.986, -35, -261.237));
	SpawnModel("me_corrugated_metal2x8",(1442.82, -59.5294, 76.4532),(273.994, -88, -90.2685));
	SpawnModel("me_corrugated_metal2x8",(1439.71, -61.3288, 42.317),(273.994, -88, -90.2685));
	SpawnModel("me_dumpster_close",(517.668, -1992.75, 16.9787),(-14, 93, 0));
	SpawnModel("me_dumpster",(407.004, -1994.38, 15.174),(-15, 62, 6));
	SpawnModel("me_concrete_barrier",(523.201, -2000.47, 74.3196),(0, -7, 10));
	SpawnModel("me_dumpster",(-422.235, -1805.92, 2.56971),(0, -7, 0));
	SpawnModel("me_dumpster",(-428.783, -1693.62, 4.69581),(0, -196, 0));
	SpawnModel("me_corrugated_metal4x8",(-396.347, -1709.87, 21.3307),(74.003, -15, 92.0119));
	SpawnModel("me_corrugated_metal4x8",(-517.69, 387.849, 268.425),(451, -90, -90.2636));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((327.125, 428.569, 65+i),(488.875, 433.201, 66+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((535.125, 398.968, 178+i),(712.875, 394.815, 177+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((855.127, 122.22, 45+i),(1192.88, 120.864, 46+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((552.865, -1964.39, 45+i),(383.156, -1962.9, 46+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-407.147, -1868.45, 40+i),(-408.799, -1641.3, 39+i));
	for(i=0;i<(2*60);i+=60)	
		CreateWalls((-1072.87, 459.192, 30+i),(-599.125, 447.684, 31+i));
	for(i=0;i<(2*60);i+=60)	
		CreateWalls((314.295, 407.125, 220+i),(285.898, 504.875, 221+i));
	CreateBlocks((1222.47, 29.4236, 195.6),(269, 0, -1));
	CreateBlocks((1440.47, -43.0689, 53.9596),(270, 0, 0));
	CreateBlocks((-600.749, 353.166, 301.69),(360, 26, 0));
	CreateBlocks((-519.644, 394.567, 260.715),(360, 0, 0));
	CreateBlocks((-668.17, 318.591, 300.825),(360, 49, 0));
	CreateBlocks((-612.619, 385.345, 169.172),(359.998, 18, -0.00108609));
	CreateBlocks((-612.702, 384.274, 252.156),(-3.60563, 23, -3.8522));
	level thread createFlag((371,-525,40));
}

Derail_Models(){
	PrecacheModel("com_steel_ladder");
	PrecacheModel("ch_crate64x64_snow");
	PrecacheModel("ch_crate32x48_snow");
	PrecacheModel("ch_crate48x64_snow");
}

Derail_Edit(){
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 250;
	SpawnModel("ch_crate64x64_snow",(1833.6, 3193.65, 422.84),(0, 0, 0));
	SpawnModel("ch_crate64x64_snow",(1828.07, 3266.03, 423.015),(0, 266.964, 0));
	SpawnModel("ch_crate64x64_snow",(1820.46, 3204.35, 487.923),(0, -8, 0));
	SpawnModel("ch_crate32x48_snow",(1833.3, 3271.62, 485.752),(0, 246.502, 0));
	SpawnModel("ch_crate48x64_snow",(1566.88, 2916.24, 173.308),(0, -23, 0));
	SpawnModel("ch_crate48x64_snow",(1579.18, 2993.49, 128.165),(0, 18, 0));
	SpawnModel("ch_crate48x64_snow",(1560.03, 3069.78, 129.564),(0, 9, 0));
	SpawnModel("ch_crate48x64_snow",(1553.58, 3140.37, 129.809),(0, 10, 0));
	SpawnModel("ch_crate48x64_snow",(1553.57, 3214.2, 136.983),(0, -11, 0));
	SpawnModel("ch_crate48x64_snow",(1545.59, 3290.64, 138.6),(0, 15, 0));
	SpawnModel("ch_crate48x64_snow",(1523.41, 3357.36, 147.816),(0, 10, 0));
	SpawnModel("ch_crate48x64_snow",(1518.22, 3433.13, 158.627),(0, 1, 0));
	SpawnModel("ch_crate48x64_snow",(1517.34, 3501.52, 171.531),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(1514.26, 3570.5, 179.377),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(1514.54, 3638.45, 183.316),(0, 4, 0));
	SpawnModel("ch_crate48x64_snow",(1514.79, 3708.82, 189.434),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(1516.66, 3780.71, 194.314),(0, 0, 0));
	SpawnModel("ch_crate48x64_snow",(1516.42, 3780.78, 241.647),(0, -12, 0));
	SpawnModel("ch_crate48x64_snow",(1511.13, 3709.87, 236.936),(0, 263.316, 0));
	SpawnModel("ch_crate48x64_snow",(1508.17, 3639.58, 231.395),(0, 260.673, 0));
	SpawnModel("ch_crate48x64_snow",(1511.96, 3571.48, 226.347),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(1516.21, 3493.73, 219.659),(0, -21, 0));
	SpawnModel("ch_crate48x64_snow",(1515.81, 3421.71, 206.669),(0, -64.2034, 0));
	SpawnModel("ch_crate48x64_snow",(1579.69, 2990.94, 175.535),(0, -19.9175, 0));
	SpawnModel("ch_crate48x64_snow",(1554.54, 3066.36, 177.713),(0, -30.9477, 0));
	SpawnModel("ch_crate48x64_snow",(1555.57, 3143.71, 179.074),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(1548.43, 3211.4, 184.596),(0, -65.0328, 0));
	SpawnModel("ch_crate48x64_snow",(1545.83, 3284.99, 186.879),(0, 18, 0));
	SpawnModel("ch_crate48x64_snow",(1519.77, 3357.44, 195.739),(0, 10, 0));
	SpawnModel("ch_crate48x64_snow",(1822.24, 3861.13, 208.61),(0, -77, 0));
	SpawnModel("ch_crate32x48_snow",(1822.32, 3858.09, 255.909),(0, -87, 0));
	SpawnModel("ch_crate64x64_snow",(2716.17, 1083.84, 126.408),(0, -91, 0));
	SpawnModel("ch_crate64x64_snow",(2648.49, 1086.77, 124.635),(0, -1, 0));
	SpawnModel("ch_crate64x64_snow",(2581.13, 1088.11, 124.604),(0, -90, 0));
	SpawnModel("ch_crate64x64_snow",(2513.69, 1087.49, 125.519),(0, -1, 0));
	SpawnModel("ch_crate64x64_snow",(2648.26, 1084.48, 188.984),(0, 53.7632, 0));
	SpawnModel("ch_crate48x64_snow",(2550.28, 1081.75, 189.472),(0, -22, 0));
	SpawnModel("ch_crate64x64_snow",(1560.17, 1504.06, 120.795),(0, 0, 0));
	SpawnModel("ch_crate64x64_snow",(1558.2, 1574.27, 118.869),(0, 269.145, 0));
	SpawnModel("ch_crate64x64_snow",(1562.19, 1650.34, 117.549),(0, 0, 0));
	SpawnModel("ch_crate64x64_snow",(1549.42, 1539.14, 182.92),(0, -83.5, 0));
	SpawnModel("ch_crate64x64_snow",(1556.62, 1612.22, 181.71),(-1, 264.327, -1));
	SpawnModel("ch_crate32x48_snow",(1560.53, 1483.8, 183.893),(0, 264.432, 0));
	SpawnModel("ch_crate32x48_snow",(1573.82, 1672.64, 181.852),(0, 249.875, 0));
	SpawnModel("ch_crate32x48_snow",(1635.81, 1675.48, 176.236),(0, -96, 5));
	SpawnModel("ch_crate64x64_snow",(2907.89, 3819.33, 22.7158),(0, 88.6283, 0));
	SpawnModel("ch_crate64x64_snow",(2902.05, 3747.5, 23.0012),(0, 82.7177, 0));
	SpawnModel("ch_crate64x64_snow",(2891.16, 3679.19, 28.7991),(0, 81.3719, 0));
	SpawnModel("ch_crate64x64_snow",(2879.71, 3609.98, 45.506),(0, 79.3559, 0));
	SpawnModel("ch_crate64x64_snow",(2869.66, 3543.81, 67.8824),(0, -8, 0));
	SpawnModel("ch_crate64x64_snow",(2862.03, 3475.14, 81.9493),(0, -2, 0));
	SpawnModel("ch_crate64x64_snow",(2861.29, 3404.81, 94.1217),(0, 96.0331, 0));
	SpawnModel("ch_crate64x64_snow",(2858.55, 3329.09, 108.546),(0, -12, 0));
	SpawnModel("ch_crate64x64_snow",(2856.83, 3254.45, 115.095),(0, 93.3909, 0));
	SpawnModel("ch_crate64x64_snow",(2859.18, 3183.67, 123.243),(0, 91.8913, 0));
	SpawnModel("ch_crate64x64_snow",(2905.48, 3805.85, 86.7334),(0, 131.156, 0));
	SpawnModel("ch_crate64x64_snow",(2890.73, 3709.12, 92.2708),(0, -1, -8));
	SpawnModel("ch_crate64x64_snow",(2885.52, 3623.91, 109.435),(0, 101.213, 0));
	SpawnModel("ch_crate64x64_snow",(2867.59, 3544.88, 131.884),(0, 75.5217, 0));
	SpawnModel("ch_crate64x64_snow",(2861.18, 3478.92, 146.006),(0, 87.8538, 0));
	SpawnModel("ch_crate64x64_snow",(2860.04, 3406.35, 157.103),(0, 89.5127, 0));
	SpawnModel("ch_crate64x64_snow",(2861.87, 3333.98, 171.341),(0, -1, 0));
	SpawnModel("ch_crate64x64_snow",(2858.74, 3256.08, 179.127),(0, 84.849, 0));
	SpawnModel("ch_crate64x64_snow",(2856.42, 3181.52, 186.522),(0, 102.048, 0));
	SpawnModel("ch_crate32x48_snow",(2920.54, 3658.07, 76.8599),(0, -100, 0));
	SpawnModel("com_steel_ladder",(1809.67, 2133.09, 305.658),(0, 178.678, 0));
	level thread CreateTeleport((1793,2133,133), (1835,2134,304.83), "ladder");
	level thread createGlassBreak((1812,2128,330), 75);
	CreateBlocks((1822.78, 3842.74, 239.873),(365.827, -173, 2.2337));
	CreateBlocks((1819.76, 3852.88, 272.082),(365.827, -173, 2.2337));
	CreateBlocks((1654.77, 1645.48, 185.116),(355.808, -23, 4.32498));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1590.38, 2950.13, 144+i),(1571.04, 3231.32, 145+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1571.04, 3231.32, 175+i),(1531.13, 3819.68, 176+i));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((2839.58, 3828.88, 40+i),(2812.6, 3154.13, 41+i));
	CreateWalls((2733.35, 3195.45, 300),(2733.33, 3739.34, 301));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2703.88, 1127.85, 157+i),(2532.13, 1128.08, 158+i));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1652.26, 1628.25, 120+i),(1657.25, 1477.13, 121+i));
	CreateWalls((1633.69, 2500.7, 315.946),(1639.22, 1976.48, 308.176));
	CreateBlocks((1793.35, 1667.46, 248.617),(360, -102, 0.0010696));
	CreateBlocks((1859.67, 3196.71, 471.042),(360, -91, 0));
	CreateBlocks((1860.62, 3260.29, 471.358),(360, -90, 0));
	CreateWalls((1597.42, 3225.67, 334),(1675.63, 3341.47, 335));
	CreateWalls((1658.42, 3114.3, 334),(1608.6, 3195.12, 335));
	//level thread createFlag((2211,2727,142));
	level thread createFlag((2251,2468,175));

}

Subbase_Edit(){
	SpawnModel("com_steel_ladder",(1078.51, -185.808, 256.245),(0, -88, 0));
	SpawnModel("ch_crate48x64_snow",(-788.187, -1866.95, 258.151),(0, -102, 0));
	SpawnModel("ch_crate48x64_snow",(-707.502, -1863.51, 255.518),(0, 82, 0));
	SpawnModel("ch_crate48x64_snow",(-758.307, -1869.88, 306.117),(0, -55, -1));
	SpawnModel("ch_crate32x48_snow",(-850.191, -1321.28, 258.221),(0, 22, 0));
	SpawnModel("ch_crate32x48_snow",(-842.976, -1323.36, 291.27),(0, 0, 0));
	SpawnModel("ch_crate48x64_snow",(879.622, -1545.64, 5.16914),(0, -88, 0));
	SpawnModel("ch_crate48x64_snow",(882.693, -1538.69, 54.2637),(0, 54.3329, 0));
	SpawnModel("ch_crate48x64_snow",(792.164, -1559.92, 0.389568),(0, -52, 0));
	SpawnModel("ch_crate48x64_snow",(709.906, -1549.85, 6.80854),(0, 86, 0));
	SpawnModel("ch_crate48x64_snow",(789.128, -1558.83, 48.4242),(0, 109.649, 0));
	SpawnModel("ch_crate48x64_snow",(711.447, -1552.28, 55.9488),(0, 1, 0));
	SpawnModel("ch_crate48x64_snow",(1646.5, -1356.76, 0.471252),(0, 60, 0));
	SpawnModel("ch_crate48x64_snow",(1570.97, -1313.37, -0.926685),(0, 56, 0));
	SpawnModel("ch_crate48x64_snow",(1610.2, -1335.58, 49.0405),(3, 61, -3));
	SpawnModel("ch_crate24x36_snow",(1558.59, -1299.93, 46.8572),(0.0319296, 0.133479, 0.11362));
	SpawnModel("ch_crate24x36_snow",(1658.83, -1361.53, 48.1696),(0.129831, -55, -0.139781));
	SpawnModel("ch_crate48x64_snow",(1475.92, 674.425, 50.1344),(0, -91, 0));
	SpawnModel("ch_crate24x36_snow",(1490.16, 682.06, 97.3715),(0.0124687, -16, 0.0129939));
	SpawnModel("ch_crate24x36_snow",(1456.58, 671.492, 97.047),(359.991, 8, 0.0104987));
	SpawnModel("ch_crate48x64_snow",(454.502, 687.027, 32.4427),(0, -91, 0));
	SpawnModel("ch_crate48x64_snow",(393.176, 697.352, 31.6078),(0, 0, 0));
	SpawnModel("ch_crate48x64_snow",(327.981, 697.241, 31.8294),(0, -41, 0));
	SpawnModel("ch_crate48x64_snow",(250.703, 675.708, 32.0469),(0, -86, 0));
	SpawnModel("ch_crate48x64_snow",(178.975, 669.476, 31.9003),(0, -84, 0));
	SpawnModel("ch_crate48x64_snow",(214.412, 671.429, 80.1933),(0, 256.333, 0));
	SpawnModel("ch_crate48x64_snow",(418.697, 691.779, 79.1085),(0, 264.518, 0));
	SpawnModel("ch_crate48x64_snow",(302.088, 684.336, 79.6002),(0, 263.068, 0));
	SpawnModel("ch_crate32x48_snow",(360.962, 707.753, 79.6973),(0, -1, 0));
	SpawnModel("ch_crate24x36_snow",(157.534, 666.009, 79.2131),(0.0224053, 0.0756598, -0.03464));
	SpawnModel("ch_crate32x48_snow",(-54.4777, 984.513, 34.4294),(0, -58, 0));
	SpawnModel("ch_crate32x48_snow",(-54.0117, 979.065, 64.5741),(0, 105, 0));
	SpawnModel("ch_crate24x36_snow",(-61.0325, 976.933, 97.0728),(0.010428, -117, 0));
	SpawnModel("ch_crate48x64_snow",(-800.793, 700.954, 113.477),(0, 249.439, 0));
	SpawnModel("ch_crate48x64_snow",(-876.271, 706.59, 109.808),(0, 109.27, 0));
	SpawnModel("ch_crate48x64_snow",(-960.723, 690.291, 107.978),(0, 269.747, 0));
	SpawnModel("ch_crate48x64_snow",(-1032.55, 703.869, 95.7744),(0, 231.416, 0));
	SpawnModel("ch_crate48x64_snow",(-1107.49, 706.003, 95.9624),(0, -1, 0));
	SpawnModel("ch_crate48x64_snow",(-1167.36, 702.007, 96.0674),(0, -85, 0));
	SpawnModel("ch_crate48x64_snow",(-1237.48, 691.894, 95.9263),(0, 211.783, 0));
	SpawnModel("ch_crate48x64_snow",(-1320.39, 707.452, 96.3917),(0, 116.158, 0));
	SpawnModel("ch_crate48x64_snow",(-1418.48, 676.108, 108.985),(0, -2, -27));
	SpawnModel("ch_crate48x64_snow",(-1481.24, 670.921, 111.558),(-1, 183.792, 28));
	SpawnModel("ch_crate48x64_snow",(-1324.37, 704.763, 144.059),(0, 255.811, 0));
	SpawnModel("ch_crate48x64_snow",(-1207.12, 699.067, 142.898),(0, 100.36, 0));
	SpawnModel("ch_crate48x64_snow",(-1136.25, 715.001, 143.599),(0, 185.466, 0));
	SpawnModel("ch_crate48x64_snow",(-1071.13, 725.052, 143.323),(0, -73, 0));
	SpawnModel("ch_crate48x64_snow",(-966.791, 692.89, 156.482),(0, 211.311, 0));
	SpawnModel("ch_crate48x64_snow",(-878.409, 710.8, 157.988),(0, -7, 0));
	SpawnModel("ch_crate48x64_snow",(-809.096, 706.115, 160.891),(0, 115.796, 0));
	SpawnModel("ch_crate24x36_snow",(-1016.82, 701.683, 143.682),(358.609, 359.846, -1.75386));
	SpawnModel("ch_crate24x36_snow",(-1259.96, 698.688, 142.919),(1.53223, 0.184409, -1.74366));
	SpawnModel("ch_crate24x36_snow",(-1486.69, 673.435, 163.235),(325.98, -89, -0.00224434));
	SpawnModel("ch_crate48x64_snow",(-1472.19, 752.325, 96.0482),(0, -83.0624, 0));
	SpawnModel("ch_crate48x64_snow",(-1410.23, 770.899, 96.3016),(0, 0, 0));
	SpawnModel("ch_crate32x48_snow",(-1423.56, 692.705, 153.001),(0, 3.13636, -29));
	SpawnModel("ch_crate32x48_snow",(-1423.56, 746.836, 142.82),(2, -87, -2));
	SpawnModel("ch_crate32x48_snow",(-1482.17, 715.61, 147.8),(-2, 0, -11));
	SpawnModel("ch_crate48x64_snow",(239.458, -974.274, 87.7961),(0, -33, 0));
	SpawnModel("ch_crate48x64_snow",(175.193, -976.088, 88.1704),(0, -3, 0));
	SpawnModel("ch_crate48x64_snow",(111.333, -965.167, 90.4728),(0, -80, 0));
	SpawnModel("ch_crate48x64_snow",(42.2877, -996.145, 87.1287),(0, -5.50415, 0));
	SpawnModel("ch_crate48x64_snow",(204.169, -975.862, 134.732),(0, -37, 0));
	SpawnModel("ch_crate48x64_snow",(73.2916, -971.464, 136.787),(0, -65, 4));
	SpawnModel("ch_crate32x48_snow",(145.494, -966.46, 137.037),(4, -5.92163, 0));
	SpawnModel("ch_crate24x36_snow",(258.729, -962.298, 135.796),(359.693, 359.911, 0.129798));
	SpawnModel("ch_crate24x36_snow",(145.46, -960.495, 168.567),(363.986, -5, -0.0173822));
	SpawnModel("ch_crate24x36_snow",(110.639, -946.332, 138.164),(0.0187542, 22, 0.0106854));
	SpawnModel("ch_crate48x64_snow",(-937.38, -961.866, 120.472),(0, -68, 0));
	SpawnModel("ch_crate48x64_snow",(-1009.36, -968.537, 119.564),(0, -16, 0));
	SpawnModel("ch_crate48x64_snow",(-1062.32, -957.832, 120.413),(0, -24.3567, 0));
	SpawnModel("ch_crate48x64_snow",(-1028.34, -965.92, 168.023),(0, 15.7874, 0));
	SpawnModel("ch_crate48x64_snow",(-968.865, -968.024, 168.061),(0, -2, 0));
	SpawnModel("ch_crate64x64",(-1182.57, -958.113, 118.073),(0, 2, 0));
	SpawnModel("ch_crate64x64",(-1251.11, -953.821, 118.082),(0, -1.9281, 0));
	SpawnModel("ch_crate32x48",(-1180.51, -947.553, 181.918),(0, 45.8295, 0));
	SpawnModel("ch_crate32x48",(-1248.15, -939.829, 182.145),(0, 67.1704, 0));
	for(i=0;i<(6*65);i+=65)
		SpawnModel("ch_crate48x64_snow",((953-i), -1543.72, 272.276),(0, -90, 0));
	SpawnModel("ch_crate32x48",(1247.36, -421.021, 79.9273),(0, -71, 0));
	SpawnModel("ch_crate32x48",(1244.96, -425.395, 111.739),(0, 165.981, 0));
	SpawnModel("ch_crate24x24",(1242.99, -434.499, 143.321),(0, 168.107, 0));
	SpawnModel("ch_crate32x48",(1132.25, -159.174, 223.341),(0, -24, 0));
	SpawnModel("ch_crate32x48",(1131.9, -161.85, 254.96),(0, -1, 0));
	SpawnModel("ch_crate24x24",(1129.37, -171.014, 286.527),(0, 96.1023, 0));
	level thread CreateTeleport((1080.93, -207.32, 112.913),(1075, -170, 239), "ladder");
	CreateBlocks((-842.976, -1317.84, 312.629),(457, 2, 2.00167));
	CreateWalls((2087.42, 3701.95, 343.793),(2251.08, 3785.73, 339.364));
	CreateBlocks((-462.634, -1829.21, 335.74),(1.02889, 0.0219372, 0.568841));
	CreateWalls((-816.874, -1833.9, 290),(-447.125, -1840.88, 291));
	CreateWalls((-1311.53, -935.133, 150),(-855.125, -935.129, 151));
	CreateWalls((-1109.71, -935.96, 176),(-1302.52, -935.125, 175));
	CreateWalls((139.125, 654.359, 65.125),(480.875, 651.057, 39.0853));
	CreateBlocks((1472.54, 640.558, 80.1245),(358.761, -1.94641, 87.6623));
	CreateBlocks((800.079, 569.99, 116.853),(2.8361, 0.164369, 10.0394));
	CreateBlocks((856.007, 568.148, 115.54),(360, 360, 0));
	CreateBlocks((-56.1118, 974.607, 90.3676),(453, -91, 0));
	CreateBlocks((860.613, 550.868, 154.671),(0, 360, 0));
	CreateBlocks((131.85, 857.149, 98.0308),(263, -2, 0));
	CreateBlocks((131.079, 682.278, 100.509),(263, -2, 0));
	CreateBlocks((625.304, 411.153, 113.066),(0, -89, -0.00150197));
	CreateWalls((1579.17, 652.44, 84.9456),(499.452, 653.774, 64.7608));
	CreateBlocks((1112.92, -161.556, 276.412),(-88.8853, 356.557, 0));
	CreateBlocks((1247.42, -433.871, 130.269),(269, 0, 0));
	CreateWalls((-1223.4, -935.126, 290.125),(-1406.88, -935.125, 288.987));
	for(i=0;i<(2*75);i+=75)
		CreateWalls((264.875, -948.472, (i+105)),(55.1257, -947.396, (i+106)));
	for(i=0;i<(4*75);i+=75)
		CreateWalls((1162.99, 448.629, (i+194)),(116.582, 597.326, (i+195)));
	for(i=0;i<(2*75);i+=75)
		CreateWalls((1543.13, -1281.12, (32+i)),(1712.88, -1359.81, (31+i)));
	CreateBlocks((799.248, 559.872, 159.306),(0, 360, 0));
	for(i=0;i<(2*75);i+=75)
		CreateWalls((919.363, -1533.13, (24+i)),(655.135, -1535.13, (25+i)));
	for(i=0;i<(2*75);i+=75)
		CreateWalls((656.208, -1535.13, (290+i)),(990.18, -1534.03, (291+i)));
	for(i=0;i<(3*75);i+=75)
		CreateWalls((-783.125, 656.433, (115+i)),(-1520.88, 649.534, (116+i)));
	level thread createFlag((217,-584,88));
}
Subbase_Models(){
	PrecacheModel("com_steel_ladder");
	PrecacheModel("ch_crate24x24");
	PrecacheModel("ch_crate32x48");
	PrecacheModel("ch_crate64x64");
	PrecacheModel("ch_crate48x64_snow");
	PrecacheModel("ch_crate24x36_snow");
	PrecacheModel("ch_crate32x48_snow");
}

Minecraft_Edit(){
	level thread createFlag((-656,-1686,-0));
	level thread CreateTeleport2((-1442,-763,-10), (-1389,-820,36),20);
	level thread CreateTeleport2((527,-2243,45), (480,-2236,47),15);
}

MinecraftSFS_Edit(){
	level thread createFlag((511,-162,0));
}

Waw_Castle_Edit(){
	level thread createFlag((2609,-1081,-459));
}

Sharqi_Day_Edit(){
	level thread createFlag((-628,3411,-247));
}

Rasalem_Edit(){
	level thread createFlag((-184,-69,2));
}

Pipeline_Edit(){
	level.randomFlagRadiusX = 200;
	level.randomFlagRadiusY = 200;
	level thread createFlag((242,1160,-8));
}

Resistance_Edit(){
	SpawnModel("paris_window_bars_08",(193.682, 1072.58, 70.786),(0, -271, 0));
	CreateBlocks((181.749, 1074.25, 23.8402),(-87.4359, 0.0404238, -0.00518417));
	SpawnModel("paris_window_bars_05",(195.865, 800.549, 48.39),(0, -90, 0));
	CreateBlocks((179.632, 801.708, 45.0968),(270.885, 358.997, 1.57524));
	SpawnModel("mil_razorwire_long_static",(-182.608, 2184.48, -17.9069),(0, -68, 0));
	SpawnModel("mil_razorwire_long_static",(-81.608, 1890.48, -15.9069),(0, -68, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-55.1414, 1840.92, (-26+i)),(-190.136, 2180.82, (-27+i)));
	SpawnModel("mil_razorwire_long_static",(68.608, 73.48, 0.9069),(0, -89, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((92.8498, -107.693, (32+i)),(69.415, 107.875, (33+i)));
	SpawnModel("mil_razorwire_long_static",(77.608, -791.48, 0.9069),(0, -89, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((95.625, -1088.13, (32+i)),(74.9419, -816.125, (31+i)));
	level thread createFlag((1609,632,-15));
	level thread CreateTeleport2((160,1077,-9), (281,1062,-21),40);
	level thread CreateTeleport2((173,797,-10), (238,797,-8),40);
	level thread CreateTeleport2((42,-10,12), (162,11,11),60);
	level thread CreateTeleport2((-81,1893,-17), (17,1930,-17),75);
	level thread CreateTeleport2((-133,2016,-17), (-28,2044,-17),75);
	level thread CreateTeleport2((-170,2141,-17), (-76,2180,-17),75);
	level thread CreateTeleport2((-124,-937,28), (141,-943,17),200);


}

Resistance_Models(){
	PrecacheModel("paris_window_bars_08");
	PrecacheModel("paris_window_bars_05");
	PrecacheModel("mil_razorwire_long_static");
}

MW2_Rust_Edit(){
	level thread createFlag((1144,718,-8));
}

Luna_Edit(){
	level thread createFlag((303,-578,290));
	setDvar("jump_height", 150);
	setDvar("g_gravity", 525);
}

Lost_Edit(){
	level thread createFlag((938,-263,15));
}

Farm_Edit(){
	level.randomFlagRadiusX = 180;
	level.randomFlagRadiusY = 180;
	level thread createFlag((910,1271,210));
}

Creek_Edit(){
	level thread createFlag((-1416,6295,-122));
}

Countdown_Edit(){
	level thread createFlag((-30,122,-23));
	level thread createSuicideHeight(-600);
}

Convoy_Edit(){
	level thread createFlag((72,308,-1));
}

bo2standoff_Edit(){
	level thread createFlag((-150,-254,10));
}

bo2carrier_Edit(){
	level thread createFlag((-4246,-43,40));
	level thread createSuicideHeight(-1000);
}

Blue_Ramshackle_Edit(){
	level thread createFlag((-509,1101,0));
}

Betatnl_Edit(){
	level thread createFlag((-439,588,-7));
}

Backlot_Edit(){
	level.randomFlagRadiusX = 500;
	level.randomFlagRadiusY = 150;
	level thread createFlag((241,2,60));
}

Summit_Edit(){
	level thread createFlag((678,1397,-40));
	level thread createSuicideHeight(-275);
}

Crash_Edit(){
	level.randomFlagRadiusX = 400;
	level.randomFlagRadiusY = 200;
	level thread createFlag((566,494,140));
}

Airport_Edit(){
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 250;
	level thread createFlag((3687,2948,320));
}

Strike_Edit(){
	level.randomFlagRadiusX = 200;
	level.randomFlagRadiusY = 200;
	level thread createFlag((209,-112,8));
}

Salvage_Edit(){
	level.randomFlagRadiusX = 50;
	level.randomFlagRadiusY = 300;
	level thread createFlag((1697,653,-2));
}

Bailout_Edit(){
	level thread createFlag((-5,-3209,645));
}

CrossFire_Edit(){
	level thread createFlag((4776,-2733,-73));
}

Nuketown_Edit(){
	level thread createFlag((41,25,-57));
}

Vacant_Edit(){
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 150;
	level thread createFlag((-131,-183,-47));
}

Invasion_Edit(){
	level.randomFlagRadiusX = 100;
	level.randomFlagRadiusY = 100;
	CreateWalls((1445.46, -2113.01, 389),(350.788, -1404.66, 381));
	CreateWalls((350.314, -1404.48, 381),(583.004, -1089.84, 382));
	CreateWalls((1774.16, -2350.24, 396.856),(1617.94, -2227, 409.943));
	CreateWalls((1151.63, -1865.72, 448.047),(1363.18, -2011.96, 469.383));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1565.11, -2239.15, (316+i)),(1483.47, -2168.62, (315+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((750.11, -1675.15, (316+i)),(697.47, -1643.62, (315+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((352.11, -1436.15, (316+i)),(410.47, -1476.62, (315+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((352.11, -1403.15, (316+i)),(397.47, -1347.62, (315+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((741.021, -819.258, (465+i)),(454.661, -1284.3, (464+i)));
	SpawnModel("me_dumpster_close",(331.462, -1354.77, 285.186),(2, -219, -3));
	SpawnModel("me_dumpster_close",(395.614, -1272.62, 286.217),(4, -218, 2));
	SpawnModel("com_vending_can_old1_lit",(338.636, -1436.93, 278.654),(0, -121, -86));
	SpawnModel("com_vending_can_old2_lit",(350.621, -1434.56, 312.883),(-2, -130, -87));
	SpawnModel("com_vending_can_old1_lit",(396.287, -1524, 288.363),(1, 53, -16));
	SpawnModel("com_mannequin1",(390.061, -1492.39, 351.207),(0, 42.3878, -87));
	SpawnModel("me_iron_gate",(719.461, -1662.73, 289.973),(0, 58, 0));
	SpawnModel("me_dumpster_close",(1526.87, -2260.06, 288.187),(0, -130, 0));
	SpawnModel("me_dumpster_close",(1446.62, -2190.42, 287.691),(0, -133, 0));
	SpawnModel("com_steel_ladder",(665.157, -1132.98, 465.697),(0, -123, 0));
	level thread CreateTeleport((646,-1157,288), (661,-1126,464), "ladder");
	level thread createFlag((1829,-1017,432));
}

Invasion_Models(){
	PrecacheModel("me_dumpster_close");
	PrecacheModel("com_vending_can_old1_lit");
	PrecacheModel("com_vending_can_old2_lit");
	PrecacheModel("com_mannequin1");
	PrecacheModel("me_iron_gate");
	PrecacheModel("com_steel_ladder");
}

Favela_Edit(){
	level.randomFlagRadiusX = 300;
	level.randomFlagRadiusY = 200;
	for(i=0;i<(4*60);i+=60)
		CreateWalls((-173.799, 1174.4, (175+i)),(-85.6689, 1174.41, (176+i)));
	CreateBlocks((833.566, 1075.25, 390.397),(89, -88, 0));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1167.13, 883.067, (220+i)),(1320.87, 882.17, (221+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((968.238, 849.126, (370+i)),(960.369, 1032.88, (371+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1494.22, 816.875, (220+i)),(1494.04, 719.125, (221+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-1024.88, 952.989, (30+i)),(-702.053, 955.086, (31+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((-685.144, 886.396, (338+i)),(-930.878, 818.786, (339+i)));
	CreateBlocks((-457.931, 1046.52, 342.882),(456, 0, 0));
	CreateBlocks((-244.683, 935.518, 199.39),(98.0482, -87, 0.0119251));
	CreateBlocks((-1338.64, 859.613, 64.2135),(0.0733086, -92, 0.0164796));
	CreateBlocks((-1361.25, 846.24, 63.9211),(0, 360, 0));
	CreateBlocks((-1427.04, 856.551, 43.4971),(21, 360, 2));
	CreateBlocks((-1363.69, 843.746, 104.415),(0.0472217, 0, -0.0817912));
	CreateBlocks((-1380.35, 848.949, 25.6887),(360, 360, 0));
	SpawnModel("me_iron_gate",(-732.451, 970.795, 12.272),(0, -89, 0));
	SpawnModel("me_iron_gate",(-859.912, 970.379, 12.8377),(0, -89, 0));
	SpawnModel("me_iron_gate",(-990.067, 970.005, 12.6038),(0, -89, 0));
	SpawnModel("me_iron_gate",(-1389.18, 830.219, 3.06264),(0, -90, 0));
	SpawnModel("me_iron_gate",(-1321.69, 895.773, 3.07576),(0, 0, 0));
	SpawnModel("com_trashcan_metal_with_trash",(-449.059, 1024.97, 288.523),(0.189737, 0.218712, -0.157453));
	SpawnModel("com_trashcan_metal_with_trash",(-443.701, 1051.15, 288.997),(0.189738, 0.218715, -0.157456));
	SpawnModel("com_trashcan_metal_with_trash",(-455.63, 1078.72, 287.494),(0.189738, 0.218715, -0.157456));
	SpawnModel("com_trashbag",(-436.526, 1034.66, 283.487),(0, 266.355, 0));
	SpawnModel("machinery_oxygen_tank02",(-435.211, 1067.47, 284.538),(-9.92386, 339.534, 0.562637));
	SpawnModel("me_iron_gate",(-127.179, 1186.78, 148.561),(0, -90, 0));
	SpawnModel("me_iron_gate",(1534.32, 768.954, 189.271),(0, 0, 0));
	SpawnModel("me_iron_gate",(1200.7, 925.495, 150.996),(0, -90, 0));
	SpawnModel("me_iron_gate",(1280.7, 927.495, 150.996),(0, -90, 0));
	SpawnModel("me_corrugated_metal8x8",(829.651, 1053.75, 394.861),(-1, 0.978443, -179.062));
	SpawnModel("me_corrugated_metal8x8",(954, 998, 409),(0, -91, 0));
	SpawnModel("me_corrugated_metal8x8",(954, 905, 409),(0, -89, 0));
	SpawnModel("com_pallet_stack",(-246.444, 951.693, 152.137),(0, -3, 0));
	SpawnModel("com_pallet_stack",(-245.743, 953.538, 184.059),(0, 7, 0));
	SpawnModel("com_ladder_wood",(-743.511, 576.749, 4.50752),(0, 0.208611, 0));
	SpawnModel("com_ladder_wood",(-743.511, 575.749, 155.50752),(0, 0.208611, 0));
	level thread CreateTeleport((-756,576,6), (-747,578,317.83), "ladder");
	SpawnModel("com_ladder_wood",(-411.5, -707.873, 5.66484),(0, 87, 0));
	level thread CreateTeleport((-407,-722,16), (-417,-695,178), "ladder");
	SpawnModel("com_ladder_wood",(-382.37, 824.37, 152.166),(0, -177, 0));
	level thread CreateTeleport((-367,825,151), (-383,828,336.125), "ladder");
	SpawnModel("com_ladder_wood",(423, 796, 4),(0, 0.208611, 0));
	SpawnModel("com_ladder_wood",(423, 796, 155),(0, 0.208611, 0));
	level thread CreateTeleport((396,796,88), (438,798,320), "ladder");
	level thread createFlag((76,-68,5));
}

Favela_Models(){
	PrecacheModel("me_corrugated_metal8x8");
	PrecacheModel("foliage_pacific_tropic_shrub03");
	PrecacheModel("me_iron_gate");
	PrecacheModel("machinery_oxygen_tank02");
	PrecacheModel("com_trashbag");
	PrecacheModel("com_pallet_stack");
	PrecacheModel("com_trashcan_metal_with_trash");
	PrecacheModel("com_ladder_wood");
}

Blog_Edit(){
	level thread createFlag((3760,775,0));
}

Blog_Summer_Edit(){
	level thread createFlag((3593,575,-1));
}

CargoShip_Edit(){
	level.randomFlagRadiusX = 400;
	level.randomFlagRadiusY = 200;
	level thread createFlag((186,0,16));
}

Quarry_Edit(){
	level.randomFlagRadiusX = 150;
	level.randomFlagRadiusY = 350;
	CreateBlocks((-3320.22, 1456.32, 51.6304),(265, -94, -1));
	CreateBlocks((-3784.37, 1762.49, 53.6792),(455, 0, 0));
	CreateWalls((-3656.88, 2001.13, 40),(-3656.47, 2158.33, 41));
	CreateWalls((-3656.88, 2001.13, 80),(-3656.47, 2158.33, 81));
	CreateBlocks((-3781.92, 1728.61, 321.682),(-0.131371, 87.5202, -268.418));
	CreateWalls((-3399.14, 2751.13, 50.11),(-3399.84, 3072.87, 51.2338));
	CreateWalls((-3399.14, 2751.13, 100.11),(-3399.84, 3072.87, 101.2338));
	CreateWalls((-1958.2, 688.098, 29.2827),(-2296.52, 687.541, 17.0659));
	CreateWalls((-1876.2, 688.098, 81.2827),(-2296.52, 687.541, 82.0659));
	CreateWalls((-1876.2, 688.098, 130.2827),(-2296.52, 687.541, 131.0659));
	CreateBlocks((-2498.21, 660.333, 188.718),(360, 0, 0));
	SpawnModel("com_steel_ladder2",(-2749.66, 1733.76, 143.889),(-11, -2, 0));
	self thread CreateTeleport((-2703,1735,16), (-2780,1736,134), "ladder");
	self thread CreateTeleport((-2780,1736,134), (-2703,1735,16), "ladder");
	SpawnModel("com_steel_ladder2",(-2376.56, 1782.76, 170.855),(6, 1, 0));
	self thread CreateTeleport((-2393,1778,28), (-2365,1769,160), "ladder");
	SpawnModel("com_steel_ladder2",(-2430.26, 2243.07, 162.657),(6, 1, 0));
	self thread CreateTeleport((-2439,2239,34), (-2429,2248,160), "ladder");
	SpawnModel("ch_crate64x64",(-1989.94, 668.555, 10.041),(0, 107.139, 0));
	SpawnModel("ch_crate64x64",(-2073.37, 669.352, 8.51999),(0, -18.9404, 0));
	SpawnModel("ch_crate64x64",(-2034.69, 665.026, 73.1237),(0, -4.6582, 0));
	SpawnModel("ch_crate64x64",(-2159.32, 667.735, 9.81435),(0, -10.8325, 0));
	SpawnModel("ch_crate64x64",(-2238.83, 649.578, 8.50954),(0, 26, 0));
	SpawnModel("ch_crate64x64",(-2197.11, 668.115, 71.6221),(0, -3.10913, 0));
	SpawnModel("ch_crate64x64",(-2114.14, 673.315, 72.928),(0, -0.961304, 0));
	SpawnModel("ch_crate64x64",(-3688.61, 2021.21, -1.92163),(0, 268.412, 0));
	SpawnModel("ch_crate64x64",(-3688.8, 2088.5, 5.92832),(0, 269.791, 0));
	SpawnModel("ch_crate64x64",(-3694.23, 2078.37, 69.5462),(0, -65, 0));
	SpawnModel("ch_crate48x64",(-3689.89, 2146.55, 10.0059),(0, 90, 0));
	SpawnModel("ch_crate48x64",(-3695.1, 2147.51, 56.9598),(0, 260.198, 1));
	SpawnModel("ch_crate48x64",(-3691.1, 2015.54, 60.599),(0, -86, 0));
	SpawnModel("ch_crate48x64",(-3806.68, 1769.55, 6.28842),(0, -1, 0));
	SpawnModel("ch_crate24x36",(-3794.52, 1767.42, 50.6177),(0.0163353, 19, 0));
	SpawnModel("ch_crate64x64",(-3422.14, 2770.98, 33.1904),(0, -2, 0));
	SpawnModel("ch_crate64x64",(-3411.83, 2841.14, 33.2326),(0, -12, 0));
	SpawnModel("ch_crate64x64",(-3408.92, 2911.81, 30.8508),(-11, -93, -5));
	SpawnModel("ch_crate64x64",(-3401.82, 2994.12, 19.5025),(0, -1, 0));
	SpawnModel("ch_crate64x64",(-3424.96, 2799.26, 96.2017),(0, 111.555, 0));
	SpawnModel("ch_crate24x36",(-3415.7, 2976.07, 81.4653),(4.2556, 0.0971195, -1.50506));
	SpawnModel("ch_crate32x48",(-3410.4, 3054.59, 18.7738),(0, -2, 0));
	SpawnModel("ch_crate32x48",(-3403.76, 3059.61, 50.0516),(0, 140.509, 0));
	SpawnModel("ch_crate32x48",(-3318.97, 1452.19, -0.143597),(0, -76, 0));
	SpawnModel("ch_crate32x48",(-3318.31, 1456.09, 31.5125),(0, -97, 0));
	SpawnModel("com_steel_ladder2",(-3780.15, 1814.28, 324.161),(0, 1, -90));
	SpawnModel("com_steel_ladder2",(-2573.32, 670.959, 183.976),(3, 89.5289, -90));
    level thread createFlag((-2562,1842,13));
}

Quarry_Models(){
	PrecacheModel("com_steel_ladder2");
	PrecacheModel("ch_crate32x48");
	PrecacheModel("ch_crate24x36");
	PrecacheModel("ch_crate64x64");
	PrecacheModel("ch_crate48x64");
}

ChemPlant_Models(){
	PrecacheModel("ch_furniture_school_lunch_table");
	PrecacheModel("furniture_icecooler01");
	PrecacheModel("vehicle_80s_sedan1_green_destructible_mp");
	PrecacheModel("ch_furniture_school_lunch_table");
}

ChemPlant_Edit(){
	SpawnModel("ch_furniture_school_lunch_table",(-874.164, 230.623, 31.1566),(-1, 0, 117));
	CreateBlocks((-872.047, 212.242, 45.669),(274, 91, 0.0245867));
	SpawnModel("furniture_icecooler01",(642.115, 418.034, 134.691),(0, 0, 0));
	CreateBlocks((638.702, 389.406, 182.214),(-90, 90, 0));
	SpawnModel("ch_furniture_school_lunch_table",(708.576, -994.233, -8.44811),(0, -1.04394, 0));
	CreateWalls((761.875, -961.534, 18.5002),(645.551, -953.875, 19.5002));
	CreateBlocks((361.109, -831.412, 65.0432),(269.995, 271.997, 0.00536153));
	CreateBlocks((294.551, -598.081, 194.689),(93, 92, 0));
	SpawnModel("ch_furniture_school_lunch_table",(-742.112, -506.782, 165.284),(-2, 89, 119));
	CreateBlocks((-710.472, -495.802, 179.617),(90.0563, 0, -1.00909));
	level thread createFlag((6,-41,11));
}

Killhouse_Edit(){
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 250;
	level thread createFlag((636,1439,40));
}

Highrise_Edit(){
	level.randomFlagRadiusX = 500;
	level.randomFlagRadiusY = 75;
	CreateBlocks((-295.896, 6773.7, 2692.52),(266, 0, 0));
	CreateBlocks((-2389.13, 6967.87, 2694.37),(455, -1, 0));
	CreateWalls((100.884, 5901.22, 3035),(94.751, 6860.09, 3036));
	CreateWalls((100.884, 5901.22, 3090),(94.751, 6860.09, 3091));
	CreateWalls((118.875, 7176.88, 2858),(118.802, 7023.13, 2857));
	CreateWalls((118.875, 7176.88, 2908),(118.802, 7023.13, 2909));
	CreateWalls((-56.0739, 6655.88, 2858.13),(-56.5302, 6351.13, 2857.13));
	CreateWalls((-56.0739, 6655.88, 2908.13),(-56.5302, 6351.13, 2909.13));
	CreateWalls((140.618, 5728.88, 2858.13),(135.434, 5575.24, 2857.13));
	CreateWalls((140.618, 5728.88, 2908.13),(135.434, 5575.24, 2909.13));
	CreateWalls((-2829.95, 5567.13, 2858.13),(-2825.78, 5720.88, 2857.13));
	CreateWalls((-2829.95, 5567.13, 2908.13),(-2825.78, 5720.88, 2909.13));
	CreateWalls((-2641.32, 6263.13, 2858.13),(-2636.8, 6472.88, 2857.13));
	CreateWalls((-2641.32, 6263.13, 2908.13),(-2636.8, 6472.88, 2909.13));
	CreateWalls((-2830.86, 7015.12, 2858.12),(-2824.92, 7168.88, 2857.13));
	CreateWalls((-2830.86, 7015.12, 2908.12),(-2824.92, 7168.88, 2909.13));
	CreateWalls((159, 7654, 3229.23),(159, 7727, 2974));
	SpawnModel("com_stepladder_large",(-2394.49, 6969.83, 2647.42),(0, 0, 0));
	SpawnModel("com_stepladder_closed",(-2364.98, 6979.88, 2648.8),(0, -92, 8));
	SpawnModel("com_stepladder_large",(-291.063, 6773.47, 2648.07),(0, -1, 0));
	SpawnModel("com_stepladder_closed",(-321.197, 6763.06, 2647.9),(0, 90, 9));
	SpawnModel("ch_crate48x64",(176.857, 7141.87, 2822.31),(0, -5, 0));
	SpawnModel("ch_crate48x64",(174.753, 7038.5, 2824.07),(0, -9, 0));
	SpawnModel("ch_crate64x64",(171.232, 7089.42, 2870.38),(-3, 268.372, -1));
	SpawnModel("com_stepladder_closed",(159.829, 7023.04, 2870.02),(0, -1, -30));
	SpawnModel("ch_crate48x64",(-6.66783, 6559.96, 2824.84),(0, 22, 0));
	SpawnModel("ch_crate48x64",(-23.4673, 6633.31, 2823.89),(0, 2, 0));
	SpawnModel("ch_crate48x64",(-15.1254, 6595.97, 2872.2),(0, -5, 0));
	SpawnModel("ch_crate48x64",(-16.1147, 6373.97, 2823.3),(0, -1, 0));
	SpawnModel("com_stepladder_large",(-17.1803, 6374.96, 2868.69),(0, 0, 0));
	SpawnModel("ch_crate64x64",(175.37, 5599.54, 2823.88),(0, -6, 0));
	SpawnModel("ch_crate64x64",(175.921, 5691.93, 2823.27),(0, -84, 0));
	SpawnModel("ch_crate64x64",(180.31, 5638.99, 2886.96),(0, 199.378, 0));
	SpawnModel("ch_crate64x64",(-2866.66, 5698.52, 2823.23),(0, 91.2723, 0));
	SpawnModel("ch_crate64x64",(-2868.25, 5612.67, 2822.76),(0, -11, 0));
	SpawnModel("ch_crate48x64",(-2867.32, 5650.76, 2886.59),(0, 81.4011, 0));
	SpawnModel("ch_crate64x64",(-2676.34, 6289.83, 2823.8),(0, 84.7135, 0));
	SpawnModel("ch_crate64x64",(-2674.04, 6445.38, 2822.39),(0, -3, 0));
	SpawnModel("ch_crate64x64",(-2678.27, 6369.39, 2822.59),(0, -88, 0));
	SpawnModel("ch_crate64x64",(-2676.28, 6409.74, 2885.42),(0, 81.1264, 0));
	SpawnModel("com_stepladder_closed",(-2678.92, 6348.25, 2885.75),(0, -185, 19));
	SpawnModel("ch_crate48x64",(-2864.97, 7037.64, 2820.24),(0, 17, 0));
	SpawnModel("ch_crate48x64",(-2869.3, 7142.6, 2823.38),(0, -26, 0));
	SpawnModel("ch_crate48x64",(-2914.58, 7089.43, 2822.89),(0, -42, 0));
	SpawnModel("ch_crate48x64",(-2878.47, 7091.35, 2869.62),(1, 30.8805, 7));
	SpawnModel("com_steel_ladder",(-2815.64, 6916.08, 2990.17),(0, 0, 0));
	SpawnModel("com_steel_ladder",(128.64, 6916.08, 3020.17),(0, -180, 0));
	self thread CreateTeleport((-2783,6918,2792), (-2799,6927,3003), "ladder");
	self thread CreateTeleport((99,6921,2792), (109,6916,3059), "ladder");
	offset = 0;
	for(i=0;i<15;i++){
		SpawnModel("ch_crate64x64",(104.427, (6830+offset), 3019.09),(0, 0, 0));
		offset -= 65;
	}
    level thread createFlag((-1412,6354,2775));
}
Highrise_Models(){
	PrecacheModel("com_steel_ladder");
	PrecacheModel("ch_crate48x64");
	PrecacheModel("ch_crate64x64");
	PrecacheModel("com_stepladder_closed");
	PrecacheModel("com_stepladder_large");
}

Scrapyard_Edit(){
    level thread createFlag((435,415,-70));
}

Shipment_Long_Edit(){
	level thread createFlag((-29,53,205));
}

Rust_Long_Edit(){
	level thread createFlag((518,992,-200));
}

Wasteland_Models(){
	PrecacheModel("ch_woodfence02");
	PrecacheModel("foliage_hedge_wall_2");
	PrecacheModel("com_woodlog_24_192_d");
}

Wasteland_Edit(){
	level.randomFlagRadiusX = 300;
	level.randomFlagRadiusY = 500;
	SpawnModel("ch_woodfence02",(822.041, -204.814, -34.9378),(0, 185, 0));
	SpawnModel("ch_woodfence02",(726.72, -213.516, -34.0827),(0, 185, 0));
	//SpawnModel("ch_woodfence02",(1346.04, -964.612, -51.082),(0, 89, 0));
	//SpawnModel("ch_woodfence02",(1349.65, -871.389, -54.8521),(0, 89, 0));
	//SpawnModel("foliage_hedge_wall_2",(1384.44, -1644.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1394.44, -1944.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1404.44, -2244.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1414.44, -2544.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1424.44, -2844.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1434.44, -3144.37, 35.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1444.44, -3444.37, 37.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1454.44, -3744.37, 40.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1464.44, -4044.37, 40.1996),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(-2030.13, -333.035, 45.2192),(13, -90, 13));
	SpawnModel("foliage_hedge_wall_2",(-2330.13, -333.035, 10.2192),(0, -90, 0));
	SpawnModel("foliage_hedge_wall_2",(-2630.13, -333.035, 20.2192),(0, -90, 0));
	SpawnModel("foliage_hedge_wall_2",(-2789.57, -313.358, 55.0417),(0, -90, 14));
	//SpawnModel("com_woodlog_24_192_d",(-2537.18, -1113.67, 90.6859),(0, 46, -40));
	//SpawnModel("com_woodlog_24_192_d",(-2516.18, -1083.67, 90.6859),(0, 46, -40));
	//SpawnModel("com_woodlog_24_192_d",(-2530.66, -1098.39, 91.8307),(0, 46, -40));
	CreateVisableRamps((-2588.05, -1038.55, 21.7094),(-2473.71, -1149.93, 158.98));
	//CreateWalls((1360.65, -839.125, -21.7293),(1355.9, -960.874, -22.0352));
	CreateWalls((691.967, -200.593, -5.2756),(826.555, -202.099, -6.7832));
	CreateWalls((-1947.31, -333.9, 95.0027),(-2836.14, -307.796, 94.5354));
	CreateWalls((-1947.31, -333.9, 35.0027),(-2836.14, -307.796, 34.5354));
	CreateWalls((1365.13, -1933.17, 60.1582),(1472.83, -3832.91, 61.1942));
	CreateWalls((1365.13, -1933.17, 120.1582),(1472.83, -3832.91, 121.1942));
	CreateWalls((1365.13, -1933.17, 180.1582),(1472.83, -3832.91, 181.1942));
	CreateWalls((1365.13, -1933.17, 240.1582),(1472.83, -3832.91, 241.1942));
	CreateWalls((1401.35, -2200.22, 301.741),(1420.66, -2590.39, 300.983));
	CreateBlocks((1365.43, -1933.33, 58.9381),(351.219, 0.749162, -4.24352));


	CreateWalls((1365.13, -1933.17, 60.1582),(1624.83, -948.91, 61.1942));
	CreateWalls((1365.13, -1933.17, 120.1582),(1624.83, -948.91, 121.1942));
	CreateWalls((1365.13, -1933.17, 180.1582),(1496.83, -1470.91, 181.1942));

	SpawnModel("foliage_hedge_wall_2",(1451.92, -1644.07, 30.8886),(0, 165, 0));
	SpawnModel("foliage_hedge_wall_2",(1524.92, -1375.07, 25.8886),(0, 165, 0));
	SpawnModel("foliage_hedge_wall_2",(1578.92, -1157.07, 25.8886),(0, 165, 0));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((1561.45, -828.875, (20+i)),(1251.13, -786.52, (21+i)));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((1594.4, -866.753, (-20+i)),(1630.11, -980.576, (-21+i)));

	SpawnModel("foliage_hedge_wall_2",(1616.75, -899.532, -20.18409),(0, 180, 0));
	SpawnModel("foliage_hedge_wall_2",(1483.75, -806.532, 25.18409),(0, -90, 0));
	SpawnModel("foliage_hedge_wall_2",(1273.75, -787.532, 80.18409),(0, -90, 0));

	level thread createFlag((-5,-1070,5));
}

Overgrown_Models(){
	PrecacheModel("h1_iw6_crates_48x64");
	PrecacheModel("h1_iw6_crates_24x36");
	PrecacheModel("com_pallet");
	PrecacheModel("h1_mp_og_propane_tank_white");
	PrecacheModel("h1_foliage_birch_01_xl_ivy");
	PrecacheModel("h1_foliage_birch_01_lg_ivy");
	PrecacheModel("h1_foliage_birch_01_xl_02");
	PrecacheModel("h1_mp_og_corrugated_metal8x8");
}

Overgrown_Edit(){
	level.randomFlagRadiusX = 300;
	level.randomFlagRadiusY = 500;
	SpawnModel("h1_iw6_crates_48x64",(692.277, -898.793, -190.938),(0, 17, 0));
	SpawnModel("h1_iw6_crates_48x64",(703.005, -825.229, -187.029),(0, -11, 0));
	SpawnModel("h1_iw6_crates_48x64",(693.536, -1095.21, -183.777),(0, -11, 0));
	SpawnModel("h1_iw6_crates_48x64",(708.929, -1028.96, -188.044),(0, -92, 0));
	SpawnModel("h1_iw6_crates_48x64",(736.157, -696.136, -167.382),(0, 233.321, 0));
	SpawnModel("h1_iw6_crates_48x64",(637.492, -568.766, -170.645),(0, -36, 0));
	SpawnModel("h1_iw6_crates_48x64",(563.512, -566.688, -175.867),(0, 19, 0));
	SpawnModel("h1_iw6_crates_48x64",(490.075, -556.701, -178.639),(0, -44.5559, 0));
	SpawnModel("h1_iw6_crates_48x64",(419.745, -565.309, -179.764),(0, 13.2432, 0));
	SpawnModel("h1_iw6_crates_48x64",(354.39, -564.402, -174.653),(0, -77, 0));
	SpawnModel("h1_iw6_crates_48x64",(289.951, -553.228, -180.862),(0, 2.21289, 0));
	SpawnModel("h1_iw6_crates_48x64",(209.08, -549.87, -187.593),(0, 35.1939, 0));
	SpawnModel("h1_iw6_crates_48x64",(142.398, -561.521, -189.25),(0, -7.82312, 0));
	SpawnModel("h1_iw6_crates_48x64",(177.161, -564.906, -140.788),(0, 16, 0));
	SpawnModel("h1_iw6_crates_48x64",(-291.235, -508.846, -185.629),(0, 23.6143, 0));
	SpawnModel("h1_iw6_crates_48x64",(-355.114, -512.484, -184.617),(0, -3.02759, 0));
	SpawnModel("h1_iw6_crates_48x64",(-323.976, -521.751, -138.954),(0, 23.1748, 0));
	SpawnModel("h1_iw6_crates_48x64",(-439.683, -522.776, -183.082),(0, -46, 0));
	SpawnModel("h1_iw6_crates_48x64",(-699.348, -518.872, -184.542),(0, -9, 0));
	SpawnModel("h1_iw6_crates_48x64",(-758.599, -530.059, -185.671),(0, 8.72229, 0));
	SpawnModel("h1_iw6_crates_48x64",(-725.324, -528.759, -137.576),(0, 23.9439, 0));
	SpawnModel("h1_iw6_crates_48x64",(-831.259, -527.626, -184.241),(0, -23.6544, 0));
	SpawnModel("h1_iw6_crates_48x64",(-894.7, -515.935, -186.8),(0, -6.77393, 0));
	SpawnModel("h1_iw6_crates_48x64",(-947.062, -507.336, -188.224),(0, -8, 0));
	SpawnModel("h1_iw6_crates_48x64",(-924.453, -513.762, -140.562),(0, -37, 0));
	SpawnModel("h1_iw6_crates_48x64",(529.09, -557.423, -128.511),(-1, 96.0138, -5));
	SpawnModel("h1_iw6_crates_24x36",(364.487, -564.911, -128.148),(1.75816, 359.881, -1.31654));
	SpawnModel("h1_iw6_crates_48x64",(711.426, -1052.92, -137.106),(-4, -15, -6));
	SpawnModel("h1_iw6_crates_24x36",(673.929, -1160.63, -175.937),(4.27951, 359.899, -5.74839));
	SpawnModel("h1_iw6_crates_24x36",(676.602, -1156.06, -152.202),(0.577574, 359.958, -4.32528));
	SpawnModel("h1_iw6_crates_24x36",(684.835, -1259.63, -174.706),(19.6786, 7.98875, 9.21445));
	SpawnModel("h1_iw6_crates_24x36",(674.501, -1353.86, -181.369),(15.281, 356.83, -2.80046));
	SpawnModel("h1_iw6_crates_24x36",(662.528, -1357.11, -141.249),(74.1454, 187.089, -168.678));
	SpawnModel("h1_iw6_crates_24x36",(683.12, -1269.34, -153.135),(21.2248, 345.815, 3.06994));
	SpawnModel("h1_iw6_crates_48x64",(694.096, -1164.93, -133.684),(10, -38, -4));
	SpawnModel("h1_iw6_crates_48x64",(672.821, -1360.68, -131.559),(-9, -8, -3));
	SpawnModel("h1_iw6_crates_48x64",(669.641, -1269.71, -129.191),(-18, -9, -2));
	SpawnModel("h1_iw6_crates_48x64",(715.485, -970.371, -192.452),(0, -79.9054, 0));
	SpawnModel("h1_iw6_crates_48x64",(708.179, -939.044, -144.438),(0, -9, 0));
	SpawnModel("h1_iw6_crates_48x64",(702.781, -833.334, -140.789),(0, -12, 0));
	SpawnModel("h1_iw6_crates_48x64",(732.136, -754.054, -181.125),(0, -7, 9));
	SpawnModel("h1_iw6_crates_24x36",(745.755, -719.889, -119.042),(0.00448314, 0.0418454, 0.00833835));
	SpawnModel("com_pallet",(-667.239, -3472.08, -59.0766),(-91, 84.9952, -83));
	SpawnModel("com_pallet",(-670.36, -3681.85, -55.876),(-91, 84.9952, -83));
	SpawnModel("h1_mp_og_propane_tank_white",(-600.945, -3975.26, -84.5491),(0, -88, -1));
	SpawnModel("h1_foliage_birch_01_xl_02",(-960.211, -4687.77, -139.872),(0, 99.224, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-907.012, -4724.44, -168.981),(0, 55.224, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-958.491, -4787.15, -165.249),(0, 144.224, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-936.951, -4839.49, -172.864),(0, 10.224, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-911.358, -4880.98, -179.259),(0, 232.224, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-944.212, -4860.6, -166.07),(0, 172.722, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-910.925, -4820.76, -163.279),(0, 172.722, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-1002.39, -4746.64, -166.823),(0, -67, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-799.538, -4679.59, -141.934),(0, -88.0535, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-837.893, -4777.82, -144.752),(0, -16, 0));
	SpawnModel("h1_foliage_birch_01_xl_02",(-829.243, -4869.74, -201.944),(0, -76.5289, 0));
	SpawnModel("h1_iw6_crates_48x64",(-54.4829, -2442.02, -219.943),(0, -23, 0));
	SpawnModel("h1_iw6_crates_48x64",(-47.3857, -2364.08, -220.804),(0, 17, 0));
	SpawnModel("h1_iw6_crates_48x64",(-370.61, -2002.87, -90.2689),(0, -24, 0));
	SpawnModel("h1_iw6_crates_48x64",(-391.301, -2034.07, -136.943),(0, 25.8307, 0));
	SpawnModel("h1_iw6_crates_48x64",(-348.969, -1976.74, -136.802),(0, -39, 0));
	SpawnModel("h1_iw6_crates_48x64",(-595.784, -2276.26, 47.2999),(0, -39, 0));
	SpawnModel("h1_iw6_crates_48x64",(-597.185, -2270.29, -0.533203),(0, -16, 0));
	SpawnModel("com_pallet",(392.64, -1651.13, -121.084),(-91, -84, 0));
	//SpawnModel("h1_mp_og_corrugated_metal8x8",(-740.956, -3326.13, -95.3829),(359.974, 0.0277569, -0.0869586));
	//SpawnModel("h1_mp_og_corrugated_metal8x8",(-740.296, -3324.92, -26.2525),(359.965, 0.855439, 1.0629));
	CreateWalls((-336.4, -1946.38, -110.877),(-400.757, -2012.62, -111.875));
	//CreateWalls((-787.871, -3334.46, -75.384),(-693.369, -3333.46, -76.3858));
	CreateBlocks((-612.43, -2264.77, 55.4835),(-90.9953, -38, 0.0111599));
	CreateWalls((-963.875, -536.465, -160.875),(659.499, -630.316, -161.875));
	CreateWalls((-963.875, -536.465, -100.875),(659.499, -630.316, -101.875));
	CreateWalls((394.499, -615.316, -40.875),(659.499, -630.316, -41.875));
	CreateWalls((623.193, -1395.41, -80.875),(690.319, -630.639, -81.875));
	CreateWalls((623.193, -1395.41, -151.875),(690.319, -630.639, -150.875));
	CreateBlocks((393.089, -1653.78, -115.336),(-88.088, -64, -20.1955));
	CreateWalls((-58.844, -2312.65, -200.535),(-77.9198, -2440.01, -201.377));
	CreateWalls((-58.844, -2312.65, -160.535),(-77.9198, -2440.01, -159.377));
	CreateBlocks((-658.565, -3681.6, -57.6),(270.776, 358.056, 0.103015));
	CreateBlocks((-660.054, -3473.12, -59.5226),(270.776, 358.056, 0.103015));
	for(i=0;i<(3*60);i+=60)
		CreateWalls((-685.112, -3847.76, (-102.875+i)),(-680.061, -4030.88, (-101.968+i)));
	CreateWalls((-951.125, -4984.88, -100.927),(-1061, -4641.13, -101.5183));
	CreateWalls((-951.125, -4984.88, -150.927),(-1061, -4641.13, -151.5183));
	level thread createFlag((-1223,-2656,-185));
}

FiringRange_Models(){
    PrecacheModel("vehicle_uaz_hardtop_destructible_mp");
    PrecacheModel("com_plasticcase_friendly");
    PrecacheModel("dest_airconditioner_01_d0");
    PrecacheModel("com_barrel_russian_fuel_dirt");
    PrecacheModel("p_rus_ladder_metal_128");
    PrecacheModel("veh_80s_sedan1_nt");
}

FiringRange_Edit(){
    SpawnModel("vehicle_uaz_hardtop_destructible_mp",(-177.997, 211.686, -111.448),(10, -136, -7));
	CreateBlocks((-76.3434, 343.336, 27.6762),(357.298, -99, -1.20594));
	CreateWalls((-148.701, 268.777, -96.3479),(-258.287, 158.072, -21.0154));
	CreateWalls((-670.701, 580.777, -40),(-764.287, 586.072, -41));
	SpawnModel("dest_airconditioner_01_d0",(-682.165, 605.44, -72.1895),(0, -79, 0));
	SpawnModel("dest_airconditioner_01_d0",(-725.923, 572.708, -74.1151),(0, 34, 0));
	SpawnModel("dest_airconditioner_01_d0",(-683.288, 599.36, -73.511),(0, -79, 0));
	SpawnModel("com_barrel_russian_fuel_dirt",(-760.184, 593.425, -74.693),(359.968, 359.609, -0.254502));
	SpawnModel("com_barrel_russian_fuel_dirt",(-744.795, 564.732, -78.1469),(0.00181295, 359.929, 5.6967));
	SpawnModel("com_barrel_russian_fuel_dirt",(-672.747, 533.244, -80.3626),(0.00172417, 359.929, 5.69822));
	SpawnModel("p_rus_ladder_metal_128",(-715.302, 577.945, -36.8136),(-78, -8, -12));
	SpawnModel("veh_80s_sedan1_nt",(1212.88, 565.235, -122.746),(2, 16, 13));
	SpawnModel("p_rus_ladder_metal_128",(1328.88, 566.403, -112.654),(-58, -6, -13));
	SpawnModel("veh_80s_sedan1_nt",(1144.07, 461.108, -114.138),(18, -114, -9));
	SpawnModel("vehicle_uaz_hardtop_destructible_mp",(1261.37, 464.381, -132.491),(-2, -318, 1));
	CreateWalls((1357.21, 584.779, -19.0462),(1083.06, 578.808, -124.326));
    level thread createFlag((357,1777,-40));
}

Terminal_Models(){
    PrecacheModel("machinery_baggage_container_blue");
    PrecacheModel("machinery_cart");
    PrecacheModel("com_copypaper_box_open");
    PrecacheModel("concrete_barrier_damaged_1");
    PrecacheModel("com_trashbag2_white");
    PrecacheModel("me_refrigerator2");
	PrecacheModel("com_steel_ladder");
	PrecacheModel("com_pipe_4x512_gas");
	PrecacheModel("com_pipe_4x96_gas");
	PrecacheModel("furniture_blowupdoll01");
	PrecacheModel("vehicle_policecar_lapd_destructible");
}

Terminal_Edits(){
	if(getDvarInt("gf_map_edit") == 1)
		Terminal_Edit_2();
	else
		Terminal_Edit();
}

Terminal_Edit(){
	level thread CreateTeleport((2216.93, 4431.32, 190.913),(2207, 4411, 317), "ladder");
	level thread CreateTeleport((1421,4399,315), (585,4804,192), "zipline");
	for(i=0;i<(11*75);i+=75)
		SpawnModel("machinery_baggage_container_blue",((600+i), 4727.69, 44.3851),(0, 0, 0));
	for(i=0;i<(11*75);i+=75)
		SpawnModel("machinery_baggage_container_blue",((600+i), 4727.69, 115.3851),(0, 0, 0));
	for(i=0;i<(7*75);i+=75)
		SpawnModel("machinery_baggage_container_blue",((900+i), 4727.69, 186.3851),(0, 0, 0));
	for(i=0;i<(7*75);i+=75)
		SpawnModel("machinery_baggage_container_blue",((900+i), 4727.69, 257.3851),(0, 0, 0));
	
	SpawnModel("furniture_blowupdoll01",(871.734, 4766.58, 219.337),(342, 91.5536, -70.0024));
	SpawnModel("furniture_blowupdoll01",(721.608, 4758.04, 241.747),(377.982, -77, -91.9953));
	SpawnModel("com_pipe_4x512_gas",(877.273, 4662.82, 322.69),(-6, -25, -27));
	SpawnModel("com_pipe_4x512_gas",(1151.5, 4534.89, 355.017),(6, 155.051, -23));
	SpawnModel("com_pipe_4x96_gas",(1382.68, 4398.63, 343.631),(53, 269.549, -11));
	SpawnModel("com_pipe_4x96_gas",(1407.66, 4431.99, 340.819),(59, 9, -9));

	SpawnModel("machinery_baggage_container_blue",(1351.64,4623.99,45.124),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4623.73,115.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4623.73,186.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4623.73,257.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4623.73,328.867),(0,0,0));

	SpawnModel("machinery_baggage_container_blue",(1351.64,4544.99,45.124),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4544.73,115.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4544.73,186.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4544.73,257.867),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1351.98,4544.73,328.867),(0,0,0));

	SpawnModel("machinery_baggage_container_blue",(80.3243, 4741.48, 198.991),(0, -270, 0));
	SpawnModel("machinery_baggage_container_blue",(5.3243, 4741.48, 198.991),(0, -270, 0));


	SpawnModel("com_trashbag2_white",(800.278, 4744.57, 202.681),(0, -11, 28));
	SpawnModel("com_trashbag2_white",(775.386, 4749.91, 203.201),(0, -11, 28));
	SpawnModel("com_trashbag2_white",(741.735, 4754.32, 203.223),(0, -11, 28));

	SpawnModel("machinery_baggage_container_blue",(1245.42, 4656.89, 39.0462),(0, -90, 0));
	SpawnModel("machinery_baggage_container_blue",(600.968, 4708.6, 186.942),(1, 102, 0));
	SpawnModel("com_trashbag2_white",(843.115,4746.72,185.395),(0,51.6323,0));
	SpawnModel("com_trashbag2_white",(808.465,4752.52,184.097),(0,64.272,0));
	SpawnModel("com_trashbag2_white",(828.914,4759.73,194.663),(0,73.127,0));
	SpawnModel("com_trashbag2_white",(780.076,4759.66,185.471),(0,72.0394,0));
	SpawnModel("com_trashbag2_white",(786.045,4764.15,201.56),(0,57.5868,0));
	SpawnModel("com_trashbag2_white",(830.569,4759.05,204.323),(0,70.8528,0));
	SpawnModel("com_trashbag2_white",(735.216,4761.53,188.481),(0,74.5772,0));
	SpawnModel("com_trashbag2_white",(748.496,4767.07,199.024),(0,66.6011,0));
	SpawnModel("com_trashbag2_white",(740.821,4739.37,187.718),(0,69.3971,0));
	SpawnModel("com_trashbag2_white",(775.113,4732.24,183.244),(0,37.5423,0));
	SpawnModel("com_trashbag2_white",(806.36,4729.03,183.069),(0,69.919,0));
	SpawnModel("com_trashbag2_white",(763.997,4758.93,212.205),(31,56.8123,-22));
	SpawnModel("com_trashbag2_white",(714.141,4744.35,180.204),(0,42.8267,0));
	SpawnModel("com_trashbag2_white",(704.619,4765.89,193.249),(0,46.8148,0));
	SpawnModel("com_trashbag2_white",(715.75,4764.66,204.044),(0,45.6722,0));
	SpawnModel("com_trashbag2_white",(735.94,4767.27,206.236),(0,21.0683,0));
	SpawnModel("com_trashbag2_white",(811.916,4752.7,217.921),(25,67.535,-27));
	SpawnModel("com_trashbag2_white",(850.271,4762.09,203.014),(0,-38.192,0));
	SpawnModel("com_trashbag2_white",(724.665,4762.85,216.6),(0,70.0179,0));
	SpawnModel("com_trashbag2_white",(748.148,4763.28,218.34),(0,-16,-23));
	SpawnModel("com_trashbag2_white",(780.248,4763.23,219.207),(-19,-51.9103,-1));
	SpawnModel("com_trashbag2_white",(580.606,4761.13,187.857),(0,-41.5043,0));
	SpawnModel("com_trashbag2_white",(601.406,4759.9,191.091),(0,-55.2867,0));
	SpawnModel("com_trashbag2_white",(579.852,4755.79,203.761),(0,-64.1417,0));
	SpawnModel("com_trashbag2_white",(643.215,4757.66,186.205),(0,-38.8127,0));
	SpawnModel("com_trashbag2_white",(678.345,4762.48,187.885),(0,-46.7393,0));
	SpawnModel("com_trashbag2_white",(623.115,4765.48,199.729),(0,-27.0024,0));
	SpawnModel("com_trashbag2_white",(662.06,4746.12,183.268),(0,36.3503,0));
	CreateBlocks((1727.06, 4414.23, 211.697),(270.992, -91, 0.312462));
	SpawnModel("com_trashbag2_white",(360, 4400, 198),(0,0,0));
	SpawnModel("me_refrigerator2",(391, 4400, 198),(-48,0,0));
	SpawnModel("concrete_barrier_damaged_1",(1437.77, 4293.07, 300.96),(0, -6, 0));
	SpawnModel("concrete_barrier_damaged_1",(1406.36, 4344.01, 301.137),(0, -80, 0));
	SpawnModel("concrete_barrier_damaged_1",(1820.45, 4290.09, 302.328),(0, -1, 0));
	SpawnModel("concrete_barrier_damaged_1",(1917.35, 4286.47, 303.574),(0, -1, 0));
	SpawnModel("concrete_barrier_damaged_1",(1994.84, 4285.33, 302.49),(0, 0, 0));
	SpawnModel("concrete_barrier_damaged_1",(2078.77, 4284.2, 303.195),(0, -3, 0));
	SpawnModel("concrete_barrier_damaged_1",(2154.63, 4278.75, 300.497),(0, 2, 0));
	SpawnModel("concrete_barrier_damaged_1",(2229.11, 4289.2, 303.628),(0, 39, 0));
	SpawnModel("concrete_barrier_damaged_1",(2263.81, 4355.86, 304.406),(0, 82.002, 0));
	SpawnModel("concrete_barrier_damaged_1",(2520.46, 4434.19, 191.918),(0, -11, 0));
	SpawnModel("concrete_barrier_damaged_1",(2339.16, 4436.26, 188.569),(0, 12, 0));
	SpawnModel("concrete_barrier_damaged_1",(2429.49, 4435.65, 190.646),(0, 0.675667, 0));
	SpawnModel("machinery_baggage_container_blue",(1724.58, 4382.33, 165.433),(0, 88, 0));
	SpawnModel("com_steel_ladder",(2212.09, 4413.11, 303.303),(-10, 90, 0));
	SpawnModel("furniture_blowupdoll01",(871.734, 4766.58, 219.337),(342, 91.5536, -70.0024));
	SpawnModel("furniture_blowupdoll01",(721.608, 4758.04, 241.747),(377.982, -77, -91.9953));
	SpawnModel("com_pipe_4x512_gas",(877.273, 4662.82, 322.69),(-6, -25, -27));
	SpawnModel("com_pipe_4x512_gas",(1151.5, 4534.89, 355.017),(6, 155.051, -23));
	SpawnModel("com_pipe_4x96_gas",(1382.68, 4398.63, 343.631),(53, 269.549, -11));
	SpawnModel("com_pipe_4x96_gas",(1407.66, 4431.99, 340.819),(59, 9, -9));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2287.13, 4424.9, (224+i)),(2672.71, 4418.88, (225+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2267.94, 4421.74, (311+i)),(2233.05, 4270.09, (312+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2201.98, 4269.49, (311+i)),(1408.43, 4289.74, (312+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1408.43, 4289.74, (312+i)),(1382.43, 4447.74, (313+i)));
	for(i=0;i<(4*60);i+=60)
		CreateWalls((1370.43, 4447.74, (220+i)),(1370.43, 4766.74, (221+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((1370.43, 4766.74, (221+i)),(612.43, 4773.74, (222+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((396.43, 4420.74, (210+i)),(315.43, 4432.74, (211+i)));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((96.43, 4772.74, (221+i)),(7.43, 4772.74, (222+i)));
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 250;
	level thread createFlag((1139,5385,220));
}

Terminal_Edit_2(){
    SpawnModel("concrete_barrier_damaged_1",(1870, 3743, 47),(0,90,0));
    SpawnModel("com_trashbag2_white",(360, 4400, 198),(0,0,0));
	SpawnModel("me_refrigerator2",(391, 4400, 198),(-48,0,0));
    SpawnModel("machinery_cart",(1427, 4155, 170),(0,0,0));
	SpawnModel("com_copypaper_box_open",(1427, 4155, 206.5),(0,80,0));
	SpawnModel("com_copypaper_box_open",(1427, 4153, 173),(0,-5,0));
    SpawnModel("machinery_baggage_container_blue",(1895, 2957, 40),(0,0,0));
	SpawnModel("machinery_baggage_container_blue",(1895, 2886, 40),(0,0,0));
	SpawnModel("vehicle_policecar_lapd_destructible",(1917, 2719, 40),(0,-90,0));
    SpawnModel("vehicle_policecar_lapd_destructible",(1973, 3050, 40),(0,150,0));

    CreateBlocks((81, 4791, 240),(0,0,0));
	CreateBlocks((13, 4791, 240),(0,0,0));
	CreateBlocks((380, 4385, 240),(0,0,0));
	CreateBlocks((528, 4655, 237),(90,90,0));
    CreateWalls((1757, 2776, 225),(1757, 3231, 223));
	CreateWalls((552, 4638, 345),(657, 4544, 350));
	CreateWalls((1861, 3363, 151),(1861, 2447, 150));
	CreateWalls((1861, 3121, 70),(1861, 2447, 71));
	CreateBlocks((1820, 3476, 140),(0,0,0));
	CreateBlocks((1820, 3442, 140),(0,0,0));
	CreateBlocks((1820, 3407, 140),(0,0,0));
	CreateBlocks((1865, 3919, 140),(0,90,0));
	CreateBlocks((1865, 3862, 140),(0,90,0));
	CreateBlocks((1882, 3743, 90),(0,90,0));
	CreateBlocks((1865, 3628, 140),(0,90,0));
	CreateBlocks((1865, 3575, 140),(0,90,0));
	CreateBlocks((1427, 4155, 208),(90,90,90));
	CreateBlocks((1399, 4453, 240),(90,90,90));
	CreateBlocks((1431, 4282, 228),(90,90,90));
	CreateBlocks((1431, 4325, 228),(90,90,90));
	level.randomFlagRadiusX = 400;
	level.randomFlagRadiusY = 400;
    level thread createFlag((1053,3648,45));
}
Afghan_Models(){
	PrecacheModel("com_plasticcase_beige_big_us_dirt");
	PrecacheModel("com_red_toolbox");
	PrecacheModel("machinery_oxygen_tank01");
	PrecacheModel("ch_crate48x64");
	PrecacheModel("com_barrel_blue_rust");
	PrecacheModel("com_barrel_tan_rust");
	PrecacheModel("com_pallet");
	PrecacheModel("utility_water_collector");
	PrecacheModel("ch_crate24x24");
	PrecacheModel("ch_mattress_3");
	PrecacheModel("me_corrugated_metal4x8");
	PrecacheModel("machinery_oxygen_tank02");
	PrecacheModel("ch_crate24x36");
	PrecacheModel("me_corrugated_metal2x4");
	PrecacheModel("ch_mattress_2");
	PrecacheModel("furniture_blowupdoll01");
	PrecacheModel("vehicle_hummer_destructible");
	PrecacheModel("me_corrugated_metal2x8");
	PrecacheModel("com_barrel_white_rust");
}
Afghan_Edit(){
	SpawnModel("com_plasticcase_beige_big_us_dirt",(2763.87, 1179.87, 55.3586),(357.382, -122, 7.84561));
	SpawnModel("com_plasticcase_beige_big_us_dirt",(2790.23, 1242.88, 55.4691),(360.361, -86, 8.09113));
	SpawnModel("com_plasticcase_beige_big_us_dirt",(2772.5, 1211.53, 82.726),(357.851, -117, 8.85954));
	SpawnModel("com_red_toolbox",(2751.84, 1170.93, 83.6938),(366.444, -242, -2.40783));
	SpawnModel("machinery_oxygen_tank01",(2757.96, 1284.51, 56.7616),(381.935, -8, 26.18));
	SpawnModel("machinery_oxygen_tank01",(2761.03, 1247.02, 48.7953),(12.5607, 19, -6.00255));
	CreateWalls((2774.07, 1263.18, 91),(2731.79, 1182.26, 90));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((2774.07, 1263.18, (150+i)),(2668.79, 1031.26, (151+i)));
	SpawnModel("ch_crate48x64",(845.482, 1379.19, 135.445),(0, 24, 0));
	SpawnModel("ch_crate48x64",(834.537, 1600.12, 142.018),(0, -29, 0));
	SpawnModel("com_barrel_blue_rust",(896.622, 1360.95, 135.079),(-3.48738, 0.33297, 4.42338));
	SpawnModel("com_barrel_tan_rust",(864.911, 1438.12, 137.46),(183.962, -86, 180.987));
	SpawnModel("com_pallet",(852.066, 1412.5, 183.467),(3, -28, -4));
	SpawnModel("com_pallet",(863.536, 1583.9, 167.718),(-3, 62, 65));
	SpawnModel("utility_water_collector",(861.479, 1532.02, 142.752),(9, -18, -5));
	SpawnModel("ch_crate24x24",(866.667, 1519.36, 184.647),(5, -84.0939, -9));
	SpawnModel("ch_mattress_3",(832.528, 1435.93, 183.657),(3, -125, 70));
	SpawnModel("me_corrugated_metal4x8",(868.278, 1483.76, 179.724),(4.4099, 4, -35.0334));
	SpawnModel("machinery_oxygen_tank02",(841.138, 1475.67, 148.652),(-9.67705, -81, -101.641));
	SpawnModel("machinery_oxygen_tank02",(841.081, 1486.73, 149.81),(326.598, -74, -105.457));
	SpawnModel("machinery_oxygen_tank02",(834.303, 1498.6, 146.652),(82.7213, -140, -147.849));
	SpawnModel("machinery_oxygen_tank02",(839.736, 1493, 155.223),(299.055, -63, -111.856));
	SpawnModel("ch_crate24x36",(818.739, 1505.35, 146.741),(7.93568, -23, 3.73303));
	SpawnModel("ch_crate24x36",(811.719, 1465.03, 146.984),(-0.435472, -30, -1.19043));
	SpawnModel("ch_crate24x36",(817.001, 1482.41, 172.369),(7.81398, 359.452, -4.18352));
	SpawnModel("me_corrugated_metal2x4",(871.673, 1631.3, 161.191),(-12.8431, 28, -41.1949));
	CreateWalls((887.852, 1348.58, 165),(877.571, 1622.99, 164));
	CreateWalls((887.852, 1348.58, 231),(877.571, 1622.99, 232));
	CreateWalls((1846.73, 2559.17, 394),(2009.59, 2607.63, 395));
	SpawnModel("ch_mattress_2",(1625.03, -167.781, 135),(0, -8, 0));
	SpawnModel("ch_mattress_3",(1622.07, -165.784, 142),(0, 7, 0));
	SpawnModel("ch_mattress_2",(1625.03, -167.781, 149),(0, -8, 0));
	SpawnModel("ch_mattress_2",(1625.03, -167.781, 156),(0, 7, 0));
	SpawnModel("ch_mattress_3",(1625.03, -167.781, 163),(0, 0, 0));
	SpawnModel("ch_mattress_2",(1625.03, -167.781, 170),(0, -8, 0));
	SpawnModel("ch_mattress_2",(1622.07, -165.784, 177),(0, 7, 0));
	SpawnModel("furniture_blowupdoll01",(1620.81, -137.608, 188.588),(357.144, -181, -93.1468));
	SpawnModel("furniture_blowupdoll01",(1873.14, 151.122, 131.695),(361.144, 182, -3.1468));
	SpawnModel("furniture_blowupdoll01",(1645.56, -179.791, 142.884),(361.144, -94, -3.1468));
	SpawnModel("furniture_blowupdoll01",(2676.1, 911.762, 202.131),(-1.96424, -100.859, 7.00412));
	SpawnModel("furniture_blowupdoll01",(2641.02, 826.632, 201.928),(-1.96424, -110, 2.00412));
	CreateWalls((1611.13, -125.029, 150.125),(1611.13, -225.658, 151.125));
	SpawnModel("vehicle_hummer_destructible",(-499.397, 351.287, 99.2358),(19, -76, -9));
	CreateWalls((-546.733, 174.273, 86),(-335.432, 323.197, 85));
	CreateWalls((-546.733, 174.273, 165),(-335.432, 323.197, 164));
	SpawnModel("com_plasticcase_beige_big_us_dirt",(3514.48, 1976.19, 40.7217),(354.999, 22, -11.777));
	SpawnModel("com_plasticcase_beige_big_us_dirt",(3458.5, 1950.33, 38.5892),(357.765, 36, -8.64393));
	SpawnModel("machinery_oxygen_tank01",(3472.56, 1993.07, 37.8498),(377.382, -114, -6.03101));
	SpawnModel("me_corrugated_metal2x8",(3503.32, 1995.34, 67.4757),(-3.38032, 24, 15.923));
	SpawnModel("ch_crate24x36",(3455.66, 1952.65, 67.808),(353.57, 6.03413, -6.05481));
	SpawnModel("com_barrel_white_rust",(3410.79, 1942.23, 38.0539),(360.506, -66, -0.81691));
	for(i=0;i<(2*60);i+=60)
		CreateWalls((3539.31, 2010.56, (70+i)),(3371.1, 1952.95, (71+i)));
	SpawnModel("ch_crate48x64",(3439.42, 3330.47, 123.478),(0, -95, 0));
	SpawnModel("ch_crate48x64",(3485.73, 3318.33, 166.886),(0, -74, -76));
	SpawnModel("com_barrel_blue_rust",(3425.72, 3337.23, 168.894),(360.208, -28, 0.644949));
	SpawnModel("com_red_toolbox",(3453.96, 3325.12, 169.579),(0.0875207, -41, 0.146407));
	SpawnModel("me_corrugated_metal2x8",(3473.37, 3321.81, 159.773),(337.782, 267.726, -173.462));
	SpawnModel("com_barrel_tan_rust",(3551.86, 3304.91, 174.193),(354.505, -11, -94.0189));
	SpawnModel("com_pallet",(3482.59, 3291.63, 151.266),(-78, 86, -8));
	CreateWalls((3551.55, 3274.41, 162),(3418.15, 3307.79, 161));
	CreateWalls((3551.55, 3274.41, 234),(3418.15, 3307.79, 235));
	SpawnModel("vehicle_hummer_destructible",(2796.85, 3252.1, 117.907),(4, -110, -2));
	CreateWalls((2764.92, 3135.9, 150),(2873.11, 3191.75, 151));
	CreateWalls((2764.92, 3135.9, 195),(2873.11, 3191.75, 196));
	level thread createFlag((1971,1311,48));
}

Rust_Edit(){
	level.randomFlagRadiusX = 250;
	level.randomFlagRadiusY = 100;
    level thread createFlag((1043,545,-201));
}

Shipment_Edit(){
	level.randomFlagRadiusX = 50;
	level.randomFlagRadiusY = 300;
    level thread createFlag((0,65,200));
}

Bloc_Edit(){
	level.randomFlagRadiusX = 300;
	level.randomFlagRadiusY = 300;
    level thread createFlag((1105,-5822,-19));
}

Village_Edit(){

}

setBotsFlagGoal(pos){
	timelimit = Float(getDvar("gf_scr_sd_timelimit"));
	wait ((timelimit*58.6)-10);
	level.botGoal = spawn( "script_model", pos );
	level.botGoal.trigger = spawn( "trigger_radius", pos, 0, 10, 20 );
}

createGlassBreak(loc, radius){
	while(1){
		foreach(player in level.players){
			if(distance(player.origin, loc) < 30)
				glassRadiusDamage( loc, radius, 100, 100 );
		}
		wait 0.025;
	}
}

CreateTeleport2(enter, exit, distRange)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(Distance(enter, player.origin) <= distRange){
				player setorigin((exit));
			}
		}
		wait 0.025;
	}
}

CreateTeleport(enter, exit, objectName)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(Distance(enter, player.origin) <= 25 && !player.ladderCooldown){
				player setLowerMessage( "ladder_info", "Hold ^3[{+activate}]^7 to use "+objectName+".", undefined, 50 );
				if(!player.clearLadderwait)
					player thread clearLadder(enter);
				if(player UseButtonPressed()){
					wait 0.1;
					if(player UseButtonPressed() && objectName == "ladder")
						player thread doLadder(enter, exit);
					if(player UseButtonPressed() && objectName == "zipline")
						player thread doZipline(enter, exit);
				}
			}
		}
		wait .25;
	}
}
doZipline(enter, exit){
	//self playlocalsound( "PG_1mc_thirdp_gtw" );
	dur = ((Distance(enter, exit))/230);
	if(dur > 3)
		dur = 3;
	else if(dur < 1)
		dur = 1;
	self.ladderCooldown = 1;
	self setLowerMessage( "ladder_info", "", undefined, 50 );
	c=spawn("script_origin",enter);
	c EnableLinkTo();
	c MoveTo((exit), dur);
	self disableweapons();
	self playerlinkto(c);
	wait dur-0.2;
	glassRadiusDamage( exit, 100, 100, 100 );
	wait 0.3;
	self notify("stop_bounce");
	self unlink();
	self enableweapons();
}

doLadder(enter, exit){
	dur = ((exit[2]-enter[2])/230);
	if(dur > 3)
		dur = 3;
	else if(dur < 1)
		dur = 1;
	self.ladderCooldown = 1;
	self setLowerMessage( "ladder_info", "", undefined, 50 );
	c=spawn("script_origin",enter);
	c EnableLinkTo();
	self disableweapons();
	self playerlinkto(c);
	if(exit[2] < enter[2]){
		c MoveTo((exit[0],exit[1],enter[2]), 0.1);
		wait 0.15;
		c MoveTo((exit[0],exit[1],exit[2]), dur);
		glassRadiusDamage( enter, 100, 100, 100 );
		wait dur+0.1;
		glassRadiusDamage( exit, 100, 100, 100 );
		wait 0.2;
	}
	else{
		c MoveTo((enter[0],enter[1],exit[2]), dur);
		glassRadiusDamage( enter, 100, 100, 100 );
		wait dur+0.1;
		c MoveTo(exit, 0.1);
		glassRadiusDamage( exit, 100, 100, 100 );
		wait 0.2;
	}
		
	self unlink();
	self enableweapons();
}

clearLadder(enter){
	self.clearLadderwait = 1;
	while(Distance(enter, self.origin) <= 25)
		wait 0.1;
	self setLowerMessage( "ladder_info", "", undefined, 50 );
	wait 1.5;
	self.ladderCooldown = 0;
	self.clearLadderwait = 0;
}

CreateViewableBlocks(pos, angle){
	block = spawn("script_model", pos );
	block setModel("com_plasticcase_friendly");
	block.angles = angle;
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
}

CreateBlocks(pos, angle){
	block = spawn("script_model", pos );
	block setModel("com_plasticcase_friendly");
	block.angles = angle;
	block Solid();
	block hide();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    if(level.hideCrates) 
        block show();
}

CreateWalls(start,end){
	D=Distance((start[0],start[1],0),(end[0],end[1],0));
	H=Distance((0,0,start[2]),(0,0,end[2]));
	blocks=roundUp(D/55);
	height=roundUp(H/30);
	CX=end[0] - start[0];
	CY=end[1] - start[1];
	CZ=end[2] - start[2];
	XA =(CX/blocks);
	YA =(CY/blocks);
	ZA =(CZ/height);
	TXA =(XA/4);
	TYA =(YA/4);
	Temp=VectorToAngles(end - start);
	Angle =(0,Temp[1],90);
	for(h=0;h < height;h++)
	{
		block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		if(level.hideCrates) 
            block show();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
		for(i=1;i < blocks;i++)
		{
			block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
			block setModel("com_plasticcase_friendly");
			block.angles=Angle;
			block Solid();
			block hide();
			if(level.hideCrates) 
                block show();
			block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			
		}
		block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		if(level.hideCrates) 
            block show();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
	}
}
CreateRamps(top,bottom){
	D=Distance(top,bottom);
	blocks=roundUp(D/30);
	CX=top[0] - bottom[0];
	CY=top[1] - bottom[1];
	CZ=top[2] - bottom[2];
	XA=CX/blocks;
	YA=CY/blocks;
	ZA=CZ/blocks;
	CXY=Distance((top[0],top[1],0),(bottom[0],bottom[1],0));
	Temp=VectorToAngles(top - bottom);
	BA =(Temp[2],Temp[1] + 90,Temp[0]);
	for(b=0;b < blocks;b++)
	{
		block=spawn("script_model",(bottom +((XA,YA,ZA)* B)));
		block setModel("com_plasticcase_friendly");
		block.angles=BA;
		block hide();
		if(level.hideCrates) 
            block show();
		block Solid();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		wait 0.01;
	}
	block=spawn("script_model",(bottom +((XA,YA,ZA)* blocks)-(0,0,5)));
	block setModel("com_plasticcase_friendly");
	block.angles =(BA[0],BA[1],0);
	block hide();
	if(level.hideCrates) 
        block show();
	block Solid();
	block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
	wait 0.01;
}

CreateVisableRamps(top,bottom){
	D=Distance(top,bottom);
	blocks=roundUp(D/30);
	CX=top[0] - bottom[0];
	CY=top[1] - bottom[1];
	CZ=top[2] - bottom[2];
	XA=CX/blocks;
	YA=CY/blocks;
	ZA=CZ/blocks;
	CXY=Distance((top[0],top[1],0),(bottom[0],bottom[1],0));
	Temp=VectorToAngles(top - bottom);
	BA =(Temp[2],Temp[1] + 90,Temp[0]);
	for(b=0;b < blocks;b++)
	{
		block=spawn("script_model",(bottom +((XA,YA,ZA)* B)));
		block setModel("com_plasticcase_friendly");
		block.angles=BA;
		block Solid();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		wait 0.01;
	}
	block=spawn("script_model",(bottom +((XA,YA,ZA)* blocks)-(0,0,5)));
	block setModel("com_plasticcase_friendly");
	block.angles =(BA[0],BA[1],0);
	block Solid();
	block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
	wait 0.01;
}

CreateWoodRamps(top,bottom){
	D=Distance(top,bottom);
	blocks=roundUp(D/65);
	CX=top[0] - bottom[0];
	CY=top[1] - bottom[1];
	CZ=top[2] - bottom[2];
	XA=CX/blocks;
	YA=CY/blocks;
	ZA=CZ/blocks;
	CXY=Distance((top[0],top[1],0),(bottom[0],bottom[1],0));
	Temp=VectorToAngles(top - bottom);
	BA =(Temp[2],Temp[1] + 90,Temp[0]);
	for(b=0;b < blocks;b++)
	{
		block=spawn("script_model",(bottom +((XA,YA,ZA)* B)));
		block setModel("ch_crate64x64");
		block.angles=BA;
	}
	block=spawn("script_model",(bottom +((XA,YA,ZA)* blocks)));
	block setModel("ch_crate64x64");
	block.angles=BA;
}

CreateAsc(depart,arivee,angle,time){
	Asc=spawn("script_model",depart);
	Asc setModel("com_plasticcase_friendly");
	Asc.angles=angle;
	Asc Solid();
	Asc CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
	Asc thread Escalator(depart,arivee,time);
}
Escalator(depart,arivee,time){
	while(1){
		if(self.state=="open"){
			self MoveTo(depart,time);wait(time*1.5);
			self.state="close";
			continue;
		}
		if(self.state=="close"){
			self MoveTo(arivee,time);
			wait(time*1.5);
			self.state="open";
			continue;
		}
	}
}

createSuicideHeight(height){
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[2] < height){
				player _suicide();
			}
		}
		wait 1;
	}
}


roundUp( floatVal )
{
	if ( int( floatVal ) != floatVal )
	{
		return int( floatVal+1 );
	}
	else
	{
		return int( floatVal );
	}
}
SpawnModel(Model,Location,andles){self endon("disconnect");Obj=spawn("script_model",Location);Obj PhysicsLaunchServer((0,0,0),(0,0,0));Obj.angles=andles;Obj setModel(Model);}


CreateWallTeleport(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin && distance(player.origin, center) < 700){
				player setorigin((exit,player.origin[1],player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport2(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin){
				player setorigin((exit,player.origin[1],player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport3(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] < wallOrigin){
				player setorigin((player.origin[0],exit,player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport4(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin){
				player setorigin((player.origin[0],exit,player.origin[2]+40));
			}
		}
		wait 0.025;
	}
}

